/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.generator.saml;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.saml11.xml.AssertionDocument;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml1x.protocol.AssertionTypeUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.generator.saml.AbstractSamlGenerator;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.generate.TokenContext;

public class Saml11TokenGenerator
extends AbstractSamlGenerator {
    AssertionTypeUtil assertionTypeUtil = new AssertionTypeUtil();
    private final ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);

    public Saml11TokenGenerator() {
        this.confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    }

    @Override
    String getGeneratorName() {
        return String.format("SAML %s Token Generator", "1.1");
    }

    @Override
    String getTokenType() {
        return Saml11SecurityToken.TYPE;
    }

    public SecurityToken generateToken(TokenContext attributeContext) throws TokenProcessingException {
        Map attributes = attributeContext.getSubjectAttributes();
        AssertionAssembler assertionAssembler = new AssertionAssembler();
        String attrNS = this.createResponseConfig.getStringValue("ns", "ns:unspecified");
        Map<String, String> attributeNamespaceMappings = Collections.emptyMap();
        AssertionType assertionType = null;
        if (this.confirmationMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) {
            Key secretKey = attributeContext.getSecretKey();
            attributeContext.setUseHolderOfKey(true);
            try {
                assertionType = assertionAssembler.assembleForWSTrust(attributes, this.assertionValidityBeforeMinutes, this.assertionValidityAfterMinutes, attrNS, this.issuer, this.audience, this.confirmationMethod, null, null, attributeNamespaceMappings, this.encryptionCertificate, secretKey);
            }
            catch (XmlException e) {
                throw new TokenProcessingException("Unable to assemble SAML 1.1 with holder-of-key confirmation.", (Throwable)e);
            }
            catch (XMLEncryptionException e) {
                throw new TokenProcessingException("Unable to assemble SAML 1.1 with holder-of-key confirmation.", (Throwable)e);
            }
        } else {
            assertionType = assertionAssembler.assembleForWSTrust(attributes, this.assertionValidityBeforeMinutes, this.assertionValidityAfterMinutes, attrNS, this.issuer, this.audience, true, this.confirmationMethod, null, null, attributeNamespaceMappings);
        }
        AssertionDocument assertionDoc = this.handleMessageCustomisation(assertionType, new AttributeMap(attributes), attributeContext.getInParameters());
        this.sign((XmlObject)assertionDoc);
        Saml11SecurityToken outToken = new Saml11SecurityToken();
        outToken.setAssertion(assertionDoc.getAssertion());
        return outToken;
    }

    @Override
    List<String> getConfirmationMethods() {
        ArrayList<String> confirmationMethods = new ArrayList<String>();
        confirmationMethods.add("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        confirmationMethods.add("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        confirmationMethods.add("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        return confirmationMethods;
    }

    private AssertionDocument handleMessageCustomisation(AssertionType assertionType, AttributeMap attributes, Map<String, Object> inParams) {
        AssertionType customisedMessage = this.handleMessageCustomisation(AssertionType.class, assertionType, attributes, inParams);
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(customisedMessage);
        return assertionDoc;
    }

    @Override
    protected String getVersion() {
        return "1.1";
    }
}

