/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import com.pingidentity.common.util.B64;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import java.security.Key;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class JwtTokenCreator
extends TokenCreator {
    @Override
    SecurityToken createTokenForActive(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx, Key proofToken, HttpServletRequest req, HttpServletResponse resp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SecurityToken createTokenForPassive(AttributeMap attrs, SpConnection sp, OutMessageContext outCtx) {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(outCtx.getVirtualServerId());
        claims.setAudience(outCtx.getEntityId());
        claims.setExpirationTimeMinutesInTheFuture((float)sp.getAssertionValidityAfterMinutes());
        claims.setNotBeforeMinutesInThePast((float)sp.getAssertionValidityBeforeMinutes());
        for (Map.Entry attrEntry : attrs.entrySet()) {
            String attrName = (String)attrEntry.getKey();
            AttributeValue attrValue = (AttributeValue)attrEntry.getValue();
            if (attrValue.isMultiValue()) {
                ArrayList valueList = new ArrayList(attrValue.getValuesAsCollection());
                claims.setStringListClaim(attrName, valueList);
                continue;
            }
            String valueStr = attrValue.getValue();
            if (valueStr == null) continue;
            claims.setStringClaim(attrName, valueStr);
        }
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)sp.getSigningKey());
        jws.setAlgorithmHeaderValue(sp.getSigningAlgorithm());
        jws.setX509CertSha1ThumbprintHeaderValue(sp.getSigningKeyCertificate().getX509Certificate());
        JwsSignatureUtil.applyProviderOverrideContextIfNeeded(jws, sp.getSigningPkCert());
        String jwt = null;
        try {
            jwt = jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new WSTrustException(e);
        }
        BinarySecurityToken token = new BinarySecurityToken(WsTrustTokenType.JWT.getUri());
        token.setEncodingType(WsTrustTokenType.BINARY.getUri());
        token.setEncodedData(B64.encode((String)jwt));
        Date date = new Date();
        long msInMin = 60000L;
        long now = date.getTime();
        Date notBefore = new Date(now - 60000L * (long)sp.getAssertionValidityBeforeMinutes());
        Date notAfter = new Date(now + 60000L * (long)sp.getAssertionValidityAfterMinutes());
        token.setCreatedDate(notBefore);
        token.setExpiryDate(notAfter);
        return token;
    }
}

