/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.sourceid.common.Util;
import org.sourceid.common.soap.soap11.SoapClientSocketFactory;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.wstrust.handlers.Saml20ResponseTokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;

public class OAuthViaSaml20TokenCreator
extends Saml20ResponseTokenCreator
implements ConfigEventListener {
    private static final String TYPE = "oauth-v2-draft10:access:token:response";
    private volatile SSLSocketFactory socketFactory;

    public OAuthViaSaml20TokenCreator() {
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        trustedCAsManager.registerForConfigEvents(this);
        this.onConfigUpdated();
    }

    @Override
    String getSysPropName() {
        return "pf.idp.wstrust.oauth-v2-draft10.via.samlp.resp";
    }

    @Override
    String getType() {
        return "oauth-v2-draft10:access:token:response|via|" + super.getType();
    }

    @Override
    BinarySecurityToken makeToken(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx) {
        String appliesTo = this.getAppliesTo(outCtx);
        String issuer = VirtualIdentityUtil.resolve((BaseMessageContext)outCtx, sp).getVirtualEntityId(DomainMode.RUNTIME);
        String base64EncodedResp = this.createWebSsoRsp(attrs, authnInst, sp, appliesTo, issuer);
        String response = this.getAccessTokenResponse(base64EncodedResp, appliesTo);
        BinarySecurityToken token = new BinarySecurityToken(XmlIDUtil.createID(), TYPE);
        token.setEncodedData(B64.encode((byte[])Util.utf8bytes(response)));
        return token;
    }

    public String getAccessTokenResponse(String encodedAssertion, String tokenEndpoint) {
        String string;
        HttpURLConnection connection;
        URL url;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "assertion");
        params.put("assertion_type", super.getType());
        params.put("assertion", encodedAssertion);
        StringBuilder builder = new StringBuilder();
        URLCodec urlCodec = new URLCodec();
        try {
            for (Map.Entry entry : params.entrySet()) {
                builder.append((String)entry.getKey()).append("=");
                builder.append(urlCodec.encode((String)entry.getValue())).append("&");
            }
        }
        catch (EncoderException e) {
            throw new WSTrustException("Problem encoding params.", e);
        }
        try {
            url = new URL(tokenEndpoint);
        }
        catch (MalformedURLException e) {
            throw new WSTrustException("Bad token endpoint url: " + tokenEndpoint);
        }
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new WSTrustException("Problem with openConnection to " + url);
        }
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
            httpsURLConnection.setSSLSocketFactory(this.socketFactory);
        }
        catch (ClassCastException httpsURLConnection) {
            // empty catch block
        }
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new WSTrustException(e);
        }
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        String postBody = builder.toString();
        byte[] postBodyBytes = Util.utf8bytes(postBody);
        String length = Integer.toString(postBodyBytes.length);
        connection.setRequestProperty("Content-Length", length);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(postBodyBytes);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new WSTrustException("Unable to post data to " + tokenEndpoint, e);
        }
        InputStream is = null;
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 404) {
                throw new WSTrustException(responseCode + " Not Found " + tokenEndpoint);
            }
            is = responseCode == 200 ? connection.getInputStream() : connection.getErrorStream();
            String contentTypeStr = connection.getContentType();
            String charset = null;
            try {
                ContentType contentType = new ContentType(contentTypeStr);
                charset = contentType.getParameter("charset");
            }
            catch (ParseException e) {
                this.log.debug((Object)("Problem parsing content type from '" + contentTypeStr + "' " + e));
            }
            String accessTokenResponse = IOUtils.toString((InputStream)is, (String)(charset == null ? "UTF-8" : charset));
            if (this.log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("response code: ").append(responseCode).append(Util.LINE_BREAK);
                sb.append("Content-Type: ").append(contentTypeStr).append(Util.LINE_BREAK);
                sb.append(accessTokenResponse);
                this.log.debug((Object)sb);
            }
            string = accessTokenResponse;
        }
        catch (IOException e) {
            try {
                throw new WSTrustException("Unable to read response from " + tokenEndpoint, e);
            }
            catch (Throwable throwable) {
                Closer.close(is);
                throw throwable;
            }
        }
        Closer.close((Closeable)is);
        return string;
    }

    @Override
    public void onConfigUpdated() {
        SoapClientSocketFactory soapClientSocketFactory = new SoapClientSocketFactory(false);
        this.socketFactory = soapClientSocketFactory.getSocketFactory();
    }
}

