/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import java.security.Key;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.StatusResponseTypeUtil;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;

public class Saml20ResponseTokenCreator
extends TokenCreator {
    final Log log = LogFactory.getLog(this.getClass());
    private final AssertionAssembler assembler = new AssertionAssembler();

    @Override
    BinarySecurityToken createTokenForActive(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx, Key key, HttpServletRequest req, HttpServletResponse resp) {
        if (Boolean.getBoolean(this.getSysPropName())) {
            return this.makeToken(attrs, authnInst, sp, outCtx);
        }
        throw new UnsupportedOperationException("Support for token type " + this.getType() + " must be enabled by setting the " + this.getSysPropName() + " system property to true (i.e. -D" + this.getSysPropName() + "=true).  If you do enable it, please ensure that the server is configured to require proper authentication to get such a token as it could potentially be (mis)used as a Web SSO Response.");
    }

    String getSysPropName() {
        return "pf.idp.wstrust.samlp.resp";
    }

    String getType() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    }

    BinarySecurityToken makeToken(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx) {
        String appliesTo = this.getAppliesTo(outCtx);
        String issuer = VirtualIdentityUtil.resolve((BaseMessageContext)outCtx, sp).getVirtualEntityId(DomainMode.RUNTIME);
        String base64encodedResp = this.createWebSsoRsp(attrs, authnInst, sp, appliesTo, issuer);
        BinarySecurityToken token = new BinarySecurityToken(XmlIDUtil.createID(), this.getType());
        token.setEncodedData(base64encodedResp);
        return token;
    }

    String createWebSsoRsp(AttributeMap attrs, Calendar authnInst, SpConnection sp, String appliesTo, String issuer) {
        AssertionType assertion;
        ResponseDocument responseDocument = ResponseDocument.Factory.newInstance();
        ResponseType responseType = responseDocument.addNewResponse();
        StatusResponseTypeUtil.setDefaults(issuer, (StatusResponseType)responseType, null);
        try {
            assertion = this.assembler.assembleForWebSSO(attrs, sp, appliesTo, null, authnInst, issuer, null);
        }
        catch (StatusResponseException e) {
            throw new WSTrustException("Problem encountered during SAML2 assertion assembly", e);
        }
        try {
            assertion = this.signatureEngine.signAssertion(assertion, sp);
        }
        catch (SigningException e) {
            throw new WSTrustException("Problem encountered during XML signing", e);
        }
        responseType.addNewAssertion().set((XmlObject)assertion);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Web SSO style Response created: " + responseDocument));
        }
        byte[] bytes = Util.utf8bytes(XmlBeansUtil.xmlText((XmlObject)responseDocument));
        return B64.encode((byte[])bytes);
    }

    String getAppliesTo(WsTrustOutMessageContext outCtx) {
        return outCtx.getInMessageContext().getRst().getAppliesTo().toString();
    }

    @Override
    public SecurityToken createTokenForPassive(AttributeMap attrs, SpConnection spConn, OutMessageContext outCtx) {
        throw new UnsupportedOperationException();
    }
}

