/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.handlers.WSTrustBaseRequestHandler;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.handlers.WSTrustLicenseChecker;
import org.sourceid.wstrust.log.STSAuditLogger;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.model.EncryptedSamlSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.RequestedProofToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.plugin.generate.TokenContext;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;
import org.sourceid.wstrust.validator.ValidateSaml11Assertion;
import org.sourceid.wstrust.validator.ValidateSaml20Assertion;
import org.w3c.dom.Element;

public class SpWSTrustRequestHandler
extends WSTrustBaseRequestHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private ValidateSaml20Assertion validateSaml20 = new ValidateSaml20Assertion();
    private ValidateSaml11Assertion validateSaml11 = new ValidateSaml11Assertion();
    private TokenPluginSupport pluginSupport = new TokenPluginSupport();
    private TokenGeneratorManager tokenGeneratorManager = GlobalRegistry.getService(TokenGeneratorManager.class);

    @Override
    String determinePartnerId(WsTrustInMessageContext inMsgCtx, RequestSecurityToken rst) {
        this.locateSubjectToken(inMsgCtx);
        SecurityToken securityToken = inMsgCtx.getSubjectSecurityToken();
        try {
            SamlSecurityToken samlSecurityToken = (SamlSecurityToken)securityToken;
            return samlSecurityToken.getIssuer();
        }
        catch (ClassCastException e) {
            STSAuditLogger.setRole("SP");
            String msg = "Only SAML 1.1 or SAML 2.0 tokens are accepted in the SP STS role. Cannot determine token issuer from non-SAML token: " + securityToken.getType();
            throw new WSTrustException(msg);
        }
    }

    @Override
    void handleValidateRequest(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, WsTrustInMessageContext inCtx, WSTrustProtocolManager protocol, WsTrustOutMessageContext outCtx) {
        boolean isValid;
        STSAuditLogger.setRole("SP");
        String tokenType = null;
        try {
            SamlSecurityToken token = this.validateInToken(req, inCtx, rst, outCtx);
            tokenType = token.getType();
            isValid = true;
        }
        catch (InvalidTokenException e) {
            boolean isValid2 = false;
            this.fillOutContext(inCtx, outCtx, protocol.transmit(isValid2), tokenType);
            WSTrustException wSTrustException = new WSTrustException("Invalid SAML token: " + e, e);
            this.log.error((Object)e);
            throw wSTrustException;
        }
        this.fillOutContext(inCtx, outCtx, protocol.transmit(isValid), tokenType);
    }

    @Override
    void handleIssueRequest(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, WsTrustInMessageContext inCtx, WSTrustProtocolManager protocol, WsTrustOutMessageContext outCtx) {
        AttributeMap srcAttributes;
        SamlSecurityToken samlInToken;
        STSAuditLogger.setRole("SP");
        try {
            samlInToken = this.validateInToken(req, inCtx, rst, outCtx);
        }
        catch (InvalidTokenException e) {
            throw new WSTrustException("Problem encountered during SAML token validation: " + e, e);
        }
        if (samlInToken.getType().equals(Saml20SecurityToken.TYPE)) {
            org.sourceid.saml20.xmlbinding.assertion.AssertionType saml20AssertionType = ((Saml20SecurityToken)samlInToken).getAssertion();
            srcAttributes = this.saml20Assembler.disassemble(saml20AssertionType);
        } else {
            AssertionType saml11AssertionType = ((Saml11SecurityToken)samlInToken).getAssertion();
            srcAttributes = this.saml1xAssembler.disassemble(saml11AssertionType, Collections.emptySet());
        }
        AttributeValue samlSubject = (AttributeValue)srcAttributes.get((Object)AssertionMapKeys.getNameIdValueKey());
        if (samlSubject != null) {
            srcAttributes.put(AssertionMapKeys.getGenericNameIdValueKey(), samlSubject);
        }
        IdpConnection idp = this.loadPartnerConnection(samlInToken);
        outCtx.setEntityId(idp.getEntityId());
        WsTrustFederatedWspSettings wsTrustSettings = idp.getWsTrustSettings();
        WsTrustTokenAttributeContract attrContract = wsTrustSettings.getAttributeContract();
        if (attrContract != null) {
            Set<String> maskedAttrs = wsTrustSettings.getAttributeContract().getMaskedAttributeNames();
            outCtx.setMaskedAttributeNames(maskedAttrs);
            srcAttributes = AttrValueSupport.setMasked((AttributeMap)srcAttributes, maskedAttrs, (boolean)false);
        }
        TokenGeneratorInstance tokenGeneratorInstance = null;
        if (inCtx.getRequestTokenGeneratorId() != null) {
            tokenGeneratorInstance = this.pluginSupport.getGeneratorInstanceFromId(inCtx.getRequestTokenGeneratorId(), outCtx.getTokenType());
        } else if (StringUtils.isNotEmpty((String)outCtx.getTokenType())) {
            tokenGeneratorInstance = this.pluginSupport.getSPGeneratorInstanceFromType(outCtx.getTokenType(), idp, inCtx.getVirtualServerId());
            this.log.debug((Object)("Generating requested TokenType from RST: " + tokenGeneratorInstance.getTokenType()));
        } else {
            String tokenPluginId = wsTrustSettings.getDefaultAssertionToTokenMappingsMappingId();
            if (tokenPluginId == null) {
                throw new WSTrustException("Default token generator not configured for IdP connection with Entity Id: " + outCtx.getEntityId());
            }
            tokenGeneratorInstance = (TokenGeneratorInstance)this.tokenGeneratorManager.getInstance(tokenPluginId);
            this.log.debug((Object)("Generating default TokenType: " + tokenGeneratorInstance.getTokenType()));
        }
        STSAuditLogger.setSTSPluginId(tokenGeneratorInstance.getId());
        this.processClaims(rst.getClaims(), wsTrustSettings.getAttributeContract(), tokenGeneratorInstance.getTokenType(), true);
        TokenPluginAttributeMapping mapping = wsTrustSettings.getAssertionToTokenMappingByGeneratorId(tokenGeneratorInstance.getId());
        if (mapping.isRestrictVirtualServerIds() && inCtx.getVirtualServerId() != null && !mapping.getRestrictedVirtualServerIds().contains(inCtx.getVirtualServerId())) {
            throw new WSTrustException("mapping " + mapping.getPluginId() + " is not allowed with mapping " + inCtx.getVirtualServerId());
        }
        AttributeMap contextAttributes = this.getContextAttributes(req);
        contextAttributes.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), inCtx.getVirtualServerId());
        HandlerUtil.addExtPropertiesToAttrMap(idp.getExtendedProperties(), contextAttributes);
        AttributeMap mappedAttrs = this.mapAttributes(srcAttributes, mapping, contextAttributes);
        String algorithm = this.getKeyProvider().getDefaultAlgorithm();
        Key serverEntropy = this.createServerEntropy(rst, algorithm);
        WSTrustBaseRequestHandler.KeyTypeKeyPair secretKeyPair = this.createProofKey(rst, serverEntropy, algorithm, false, true);
        HashMap<String, XmlObject> inParamForTokenGenerator = new HashMap<String, XmlObject>();
        inParamForTokenGenerator.put("RequestSecurityToken", inCtx.getRstXmlObject());
        inParamForTokenGenerator.put("IncomingSamlAssertion", samlInToken.getAssertion());
        TokenContext tokenContext = new TokenContext();
        tokenContext.setSubjectAttributes((Map)mappedAttrs);
        tokenContext.setSecretKey(secretKeyPair.getKey());
        tokenContext.setInParameters(inParamForTokenGenerator);
        SecurityToken outToken = this.pluginSupport.generateToken(tokenGeneratorInstance, tokenContext);
        STSAuditLogger.setAttributes(mappedAttrs);
        STSAuditLogger.auditOutTokenForRst(outToken);
        RequestSecurityTokenResponse rstr = protocol.transmit(outToken);
        RequestedProofToken proofToken = this.createProofToken(rst, secretKeyPair, serverEntropy, tokenContext.isUseHolderOfKey());
        if (proofToken != null) {
            rstr.setRequestedProofToken(proofToken);
        }
        this.fillOutContext(inCtx, outCtx, rstr, samlInToken.getType());
    }

    private SamlSecurityToken validateInToken(HttpServletRequest req, WsTrustInMessageContext inCtx, RequestSecurityToken rst, WsTrustOutMessageContext outCtx) throws InvalidTokenException {
        AttributeMap attributes;
        IdpConnection idp;
        this.locateSubjectToken(inCtx);
        SecurityToken token = inCtx.getSubjectSecurityToken();
        SamlSecurityToken samlToken = null;
        if (token instanceof EncryptedSamlSecurityToken) {
            try {
                token = this.decrypt(token);
            }
            catch (XMLEncryptionException e) {
                throw new WSTrustException("Unable to decrypt incoming SAML 2.0 assertion.", e);
            }
        }
        if ((idp = this.loadPartnerConnection(samlToken = this.ensureSamlToken(token))).getWsTrustSettings() == null) {
            throw new ProcessRuntimeException("WsTrustSettings are not present for IDP connection with entityId: " + idp.getEntityId());
        }
        inCtx.setEntityId(idp.getEntityId());
        STSAuditLogger.setConnectionId(idp.getEntityId());
        STSAuditLogger.setConnectionName(idp.getName());
        String virtualServerId = VirtualIdentityUtil.resolve(idp, req).getVirtualEntityId(DomainMode.RUNTIME);
        STSAuditLogger.setVirtualServerId(virtualServerId);
        inCtx.setVirtualServerId(virtualServerId);
        outCtx.setVirtualServerId(virtualServerId);
        this.validateSignature(samlToken.getAssertionDom(), idp);
        List<String> virtualEntityIds = VirtualIdentityUtil.getAllowedAudiences(inCtx, idp);
        if (samlToken.getType().equals(Saml20SecurityToken.TYPE)) {
            org.sourceid.saml20.xmlbinding.assertion.AssertionType saml20AssertionType = ((Saml20SecurityToken)samlToken).getAssertion();
            this.validateSaml20.validate((Saml20SecurityToken)samlToken, virtualEntityIds);
            attributes = this.saml20Assembler.disassemble(saml20AssertionType);
        } else {
            AssertionType saml11AssertionType = ((Saml11SecurityToken)samlToken).getAssertion();
            this.validateSaml11.validate((Saml11SecurityToken)samlToken, virtualEntityIds);
            attributes = this.saml1xAssembler.disassemble(saml11AssertionType, Collections.emptySet());
        }
        WsTrustTokenAttributeContract attrContract = idp.getWsTrustSettings().getAttributeContract();
        if (attrContract != null) {
            attributes = AttrValueSupport.setMasked((AttributeMap)attributes, attrContract.getMaskedAttributeNames(), (boolean)false);
        }
        STSAuditLogger.setUserName(((AttributeValue)attributes.get((Object)"SAML_SUBJECT")).getValue(true));
        if (RequestType.VALIDATE == rst.getRequestType()) {
            STSAuditLogger.setAttributes(attributes);
        }
        return samlToken;
    }

    private void validateSignature(Element saml, IdpConnection idp) throws InvalidTokenException {
        SignatureResult signatureResult = this.signatureEngine.verifyXmlSignature(saml, (ConnectionBase)idp);
        if (SignatureStatus.VALID != signatureResult.getStatus()) {
            throw new InvalidTokenException("Signature on SAML token is " + signatureResult);
        }
    }

    private IdpConnection loadPartnerConnection(SamlSecurityToken saml) {
        IdpConnection idpConn = this.metadataDirectory.getIdpConnection(saml.getIssuer(), false);
        if (idpConn == null) {
            throw new WSTrustException("No WS-Trust connection is configured for issuer: " + saml.getIssuer());
        }
        if (!idpConn.isActive()) {
            this.log.info((Object)"An IdP connection was found for the incoming RST but the connection is not active. The RST will be rejected.");
            throw new WSTrustException("IdP connection not active");
        }
        WSTrustLicenseChecker.checkLicense(idpConn);
        return idpConn;
    }

    private SamlSecurityToken ensureSamlToken(SecurityToken token) {
        String type = token.getType();
        if (!type.equals(Saml20SecurityToken.TYPE) && !type.equals(Saml11SecurityToken.TYPE)) {
            throw new WSTrustException("SP side supports only SAML 1.1/2.0 tokens but received " + type);
        }
        return (SamlSecurityToken)token;
    }

    public void setSaml20Validator(ValidateSaml20Assertion validateSaml20) {
        this.validateSaml20 = validateSaml20;
    }

    public void setSaml11Validator(ValidateSaml11Assertion validateSaml11) {
        this.validateSaml11 = validateSaml11;
    }

    public void setPluginSupport(TokenPluginSupport pluginSupport) {
        this.pluginSupport = pluginSupport;
    }

    public void setTokenGeneratorManager(TokenGeneratorManager tokenGeneratorManager) {
        this.tokenGeneratorManager = tokenGeneratorManager;
    }
}

