/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Token2TokenManager;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.UsernameToken;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;
import org.sourceid.wstrust.plugin.process.FailedAuthnException;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenPluginDescriptor;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.wsse.WsseProcessingException;

public class TokenPluginSupport {
    private static final String EXCEPTION_NO_TP_FOR_ID = "No token processor instance configured for plugin ID: ";
    private static final String EXCEPTION_NO_TG_FOR_ID = "No token generator instance configured for plugin ID: ";
    private static final String EXCEPTION_OUT_TOKEN_TYPE_MISMATCH = "The requested out token type does not match the requested token generator's token type";
    private static final String EXCEPTION_NO_TP_FOR_TOKEN_TYPE = "No token processor configured for token type: ";
    private static final String EXCEPTION_NO_TG_FOR_TOKEN_TYPE = "No token generator configured for token type: ";
    private static final String EXCEPTION_MULTIPLE_TG_FOR_TOKEN_TYPE = "Multiple token generators are configured for the specified token type. URL parameter TokenGeneratorId must be specified";
    private static final String EXCEPTION_MULTIPLE_TP_FOR_TOKEN_TYPE = "Multiple token processors are configured for the specified token type. URL parameter TokenProcessorId must be specified";
    private static final String EXCEPTION_NOT_ENOUGH_INFO_FOR_TG = "Token generator lookup failed. Missing TokenGeneratorId or token type";
    private static final String EXCEPTION_TOKEN_GENERATION_FAILED = "Failed to generate token";
    private final TokenProcessorManager tokenProcessorManager = GlobalRegistry.getService(TokenProcessorManager.class);
    private final TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
    private final Token2TokenManager token2TokenManager = MgmtFactory.getToken2TokenManager();

    public SecurityToken generateToken(TokenGeneratorInstance tokenGeneratorInstance, org.sourceid.wstrust.plugin.generate.TokenContext tokenContext) {
        try {
            TokenGenerator tokenGenerator = this.tokenGeneratorManager.getTokenGenerator(tokenGeneratorInstance.getId());
            return tokenGenerator.generateToken(tokenContext);
        }
        catch (TokenProcessingException e) {
            throw new WSTrustException(EXCEPTION_TOKEN_GENERATION_FAILED, e);
        }
    }

    public AttributeMap processToken(TokenProcessorInstance processorInstance, SecurityToken inToken, WsTrustInMessageContext inCtx) {
        String id = processorInstance.getId();
        TokenProcessor<SecurityToken> processor = this.tokenProcessorManager.getTokenProcessor(id);
        if (inToken instanceof UsernameToken) {
            ((UsernameToken)inToken).setRequestIpAddress(inCtx.getRequestIpAddress());
        }
        AttributeMap resultMap = this.processToken(processor, inToken, inCtx);
        resultMap = AttrValueSupport.setMasked((AttributeMap)resultMap, processorInstance.getMaskedFields(), (boolean)processorInstance.getMaskOgnlValues());
        return resultMap;
    }

    <T extends SecurityToken> AttributeMap processToken(TokenProcessor<T> processor, SecurityToken inToken, WsTrustInMessageContext inCtx) {
        Class<T> expectedTokenClass = this.getExpectedTokenTypeClass(processor);
        if (!expectedTokenClass.isInstance(inToken)) {
            TokenPluginDescriptor pluginDescriptor = processor.getPluginDescriptor();
            String expectedTokenType = pluginDescriptor.getTokenType();
            String expectedClassName = expectedTokenClass.getName();
            String type = inToken.getType();
            String name = inToken.getClass().getName();
            String msg = "Token type mismatch: received %s / %s but expected %s / %s";
            msg = String.format(msg, name, type, expectedClassName, expectedTokenType);
            throw new WSTrustException(msg);
        }
        try {
            TokenContext tokenContext = this.invokeProcess(processor, inToken);
            if (tokenContext == null) {
                return new AttributeMap();
            }
            Map subjectAttributes = tokenContext.getSubjectAttributes();
            AttributeMap attributeMap = new AttributeMap();
            attributeMap.putAll(subjectAttributes);
            return attributeMap;
        }
        catch (InvalidTokenException e) {
            WSTrustException invalidSecTokenException = new WSTrustException("Invalid Token: " + e.getMessage(), e);
            invalidSecTokenException.setFaultCode(WSTrustException.FaultCode.INVALID_SECURITY_TOKEN, inCtx.getWsTrustVersion());
            invalidSecTokenException.setRelatesTo(inCtx.getSoapHeaders().getMessageId());
            invalidSecTokenException.setWsaVersion(inCtx.getWsaVersion());
            throw invalidSecTokenException;
        }
        catch (FailedAuthnException e) {
            WsseProcessingException failedAuthnException = new WsseProcessingException("Failed Authentication: " + e.getMessage(), e);
            failedAuthnException.setRelatesTo(inCtx.getSoapHeaders().getMessageId());
            failedAuthnException.setWsaVersion(inCtx.getWsaVersion());
            failedAuthnException.setFaultCode(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication"));
            throw failedAuthnException;
        }
        catch (TokenProcessingException e) {
            throw new WSTrustException("Unexpected problem evaluating Token", e);
        }
    }

    private <T extends SecurityToken> TokenContext invokeProcess(TokenProcessor<T> processor, T inToken) throws TokenProcessingException, InvalidTokenException {
        return processor.processToken(inToken);
    }

    public final <T extends SecurityToken> Class<T> getExpectedTokenTypeClass(TokenProcessor<T> tp) {
        Type[] genericInterfaces;
        Class<?> tpClass = tp.getClass();
        for (Type type : genericInterfaces = tpClass.getGenericInterfaces()) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().equals(TokenProcessor.class)) continue;
            for (Type actualType : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                if (!(actualType instanceof Class)) continue;
                try {
                    return (Class)actualType;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return SecurityToken.class;
    }

    public TokenGeneratorInstance getGeneratorInstanceFromId(String instanceId, String outTokenType) {
        TokenGeneratorInstance generatorInstance = (TokenGeneratorInstance)this.tokenGeneratorManager.getInstance(instanceId);
        if (generatorInstance == null) {
            throw new WSTrustException(EXCEPTION_NO_TG_FOR_ID + instanceId);
        }
        if (StringUtils.isNotEmpty((String)outTokenType) && !outTokenType.equals(generatorInstance.getTokenType())) {
            throw new WSTrustException(EXCEPTION_OUT_TOKEN_TYPE_MISMATCH);
        }
        return generatorInstance;
    }

    public TokenProcessorInstance getProcessorInstanceFromId(String instanceId) {
        TokenProcessorInstance processorInstance = (TokenProcessorInstance)this.tokenProcessorManager.getInstance(instanceId);
        if (processorInstance == null) {
            throw new WSTrustException(EXCEPTION_NO_TP_FOR_ID + instanceId);
        }
        return processorInstance;
    }

    public TokenGeneratorInstance getSPGeneratorInstanceFromType(String outTokenType, IdpConnection idp) {
        return this.getSPGeneratorInstanceFromType(outTokenType, idp, null);
    }

    public TokenGeneratorInstance getSPGeneratorInstanceFromType(String outTokenType, IdpConnection idp, String virtualServerId) {
        List<TokenGeneratorInstance> incomingTokenGenerators = this.getIncomingTokenGenerators(idp, virtualServerId);
        if (StringUtils.isEmpty((String)outTokenType)) {
            if (incomingTokenGenerators.size() == 1) {
                return incomingTokenGenerators.get(0);
            }
            throw new WSTrustException(EXCEPTION_NOT_ENOUGH_INFO_FOR_TG);
        }
        List spTokenGenerators = this.tokenGeneratorManager.getInstancesForTokenType(outTokenType);
        spTokenGenerators.retainAll(incomingTokenGenerators);
        if (spTokenGenerators.isEmpty()) {
            throw new WSTrustException(EXCEPTION_NO_TG_FOR_TOKEN_TYPE + outTokenType);
        }
        if (spTokenGenerators.size() > 1) {
            throw new WSTrustException(EXCEPTION_MULTIPLE_TG_FOR_TOKEN_TYPE);
        }
        return (TokenGeneratorInstance)spTokenGenerators.get(0);
    }

    private List<TokenGeneratorInstance> getIncomingTokenGenerators(IdpConnection idp, String virtualServerId) {
        WsTrustFederatedWspSettings wsTrustSettings = idp.getWsTrustSettings();
        Set<String> incomingTokenGenerators = wsTrustSettings.getIncomingTokenGenerators();
        ArrayList<TokenGeneratorInstance> incomingTokenGeneratorInstances = new ArrayList<TokenGeneratorInstance>(incomingTokenGenerators.size());
        for (String incomingTokenGenerator : incomingTokenGenerators) {
            TokenGeneratorInstance tokenGeneratorInstance = (TokenGeneratorInstance)this.tokenGeneratorManager.getInstance(incomingTokenGenerator);
            TokenPluginAttributeMapping mapping = wsTrustSettings.getAssertionToTokenMappingByGeneratorId(tokenGeneratorInstance.getId());
            if (mapping.isRestrictVirtualServerIds() && virtualServerId != null && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
            incomingTokenGeneratorInstances.add(tokenGeneratorInstance);
        }
        return incomingTokenGeneratorInstances;
    }

    public TokenGeneratorInstance getT2TGeneratorInstanceFromType(String outTokenType) {
        ArrayList<TokenGeneratorInstance> supportedTokenGeneratorInstances = new ArrayList<TokenGeneratorInstance>(this.token2TokenManager.getMappingCount());
        for (Token2TokenMapping token2TokenMapping : this.token2TokenManager.getMappings()) {
            supportedTokenGeneratorInstances.add(this.getGeneratorInstanceFromId(token2TokenMapping.getTargetId(), null));
        }
        if (StringUtils.isEmpty((String)outTokenType)) {
            if (supportedTokenGeneratorInstances.size() == 1) {
                return (TokenGeneratorInstance)supportedTokenGeneratorInstances.get(0);
            }
            throw new WSTrustException(EXCEPTION_NOT_ENOUGH_INFO_FOR_TG);
        }
        List matchingGenerators = this.tokenGeneratorManager.getInstancesForTokenType(outTokenType);
        matchingGenerators.retainAll(supportedTokenGeneratorInstances);
        if (matchingGenerators.isEmpty()) {
            throw new WSTrustException(EXCEPTION_NO_TG_FOR_TOKEN_TYPE + outTokenType);
        }
        if (matchingGenerators.size() > 1) {
            throw new WSTrustException(EXCEPTION_MULTIPLE_TG_FOR_TOKEN_TYPE);
        }
        return (TokenGeneratorInstance)matchingGenerators.get(0);
    }

    public TokenProcessorInstance getT2TProcessorInstanceFromType(RequestType requestType, SecurityToken inToken) {
        String tokenType = inToken.getType();
        List tokenProcessorInstances = this.tokenProcessorManager.getInstancesForTokenType(tokenType);
        ArrayList<TokenProcessorInstance> supportedTokenProcessorInstances = new ArrayList<TokenProcessorInstance>(this.token2TokenManager.getMappingCount());
        for (Token2TokenMapping token2TokenMapping : this.token2TokenManager.getMappings()) {
            supportedTokenProcessorInstances.add(this.getProcessorInstanceFromId(token2TokenMapping.getSourceId()));
        }
        if (StringUtils.isEmpty((String)tokenType)) {
            if (supportedTokenProcessorInstances.size() == 1) {
                return (TokenProcessorInstance)supportedTokenProcessorInstances.get(0);
            }
            throw new WSTrustException(EXCEPTION_NOT_ENOUGH_INFO_FOR_TG);
        }
        if (requestType == RequestType.ISSUE) {
            tokenProcessorInstances.retainAll(supportedTokenProcessorInstances);
        }
        if (tokenProcessorInstances.isEmpty()) {
            throw new WSTrustException(EXCEPTION_NO_TP_FOR_TOKEN_TYPE + tokenType);
        }
        if (tokenProcessorInstances.size() > 1) {
            throw new WSTrustException(EXCEPTION_MULTIPLE_TP_FOR_TOKEN_TYPE);
        }
        return (TokenProcessorInstance)tokenProcessorInstances.get(0);
    }

    public TokenProcessorInstance getIdpProcessorInstanceFromType(SecurityToken inToken, SpConnection sp) {
        return this.getIdpProcessorInstanceFromType(inToken, sp, null);
    }

    public TokenProcessorInstance getIdpProcessorInstanceFromType(SecurityToken inToken, SpConnection sp, String virtualServerId) {
        String tokenType = inToken.getType();
        List idpTokenProcessors = this.tokenProcessorManager.getInstancesForTokenType(tokenType);
        if (sp != null && sp.getWsTrustSettings() != null) {
            List<TokenProcessorInstance> incomingTokenProcessors = this.getIncomingTokenProcessors(sp, virtualServerId);
            idpTokenProcessors.retainAll(incomingTokenProcessors);
        }
        if (idpTokenProcessors.isEmpty()) {
            throw new WSTrustException(EXCEPTION_NO_TP_FOR_TOKEN_TYPE + tokenType);
        }
        if (idpTokenProcessors.size() > 1) {
            throw new WSTrustException(EXCEPTION_MULTIPLE_TP_FOR_TOKEN_TYPE);
        }
        return (TokenProcessorInstance)idpTokenProcessors.get(0);
    }

    private List<TokenProcessorInstance> getIncomingTokenProcessors(SpConnection sp, String virtualServerId) {
        WsTrustFederatedWscSettings wsTrustSettings = sp.getWsTrustSettings();
        Set<String> tokenProcessors = wsTrustSettings.getIncomingTokenProcessors();
        ArrayList<TokenProcessorInstance> incomingTokenProcessorInstances = new ArrayList<TokenProcessorInstance>(tokenProcessors.size());
        for (String tokenProcessor : tokenProcessors) {
            TokenProcessorInstance tokenProcessorInstance = this.getProcessorInstanceFromId(tokenProcessor);
            TokenPluginAttributeMapping mapping = wsTrustSettings.getTokenToAssertionMappingByProcessorId(tokenProcessorInstance.getId());
            if (mapping.isRestrictVirtualServerIds() && virtualServerId != null && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
            incomingTokenProcessorInstances.add(tokenProcessorInstance);
        }
        return incomingTokenProcessorInstances;
    }
}

