/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.LicenseObject;
import org.sourceid.util.license.PingLicense;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.wstrust.handlers.WSTrustException;

public class WSTrustLicenseChecker {
    public static final String MODULE_NAME_IN_LICENSE_WS_TRUST_STS = "WSTrustSTS";

    public static boolean isEnabled() {
        boolean enabled = false;
        PingLicense license = LicenseManager.getLicense();
        if (license.isFeatureEnabled(MODULE_NAME_IN_LICENSE_WS_TRUST_STS)) {
            enabled = true;
        }
        return enabled;
    }

    public static void checkLicense(LicenseObject conn) {
        if (conn != null) {
            if (!WSTrustLicenseChecker.isEnabled()) {
                throw new WSTrustException("You need to have a license for WS-Trust STS.");
            }
            try {
                LicenseManager.checkLicenseForConnection(conn);
            }
            catch (ProcessRuntimeException ex) {
                throw new WSTrustException(ex.getMessage());
            }
        }
    }
}

