/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.log;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.common.Util;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.UsernameToken;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.model.X509SecurityToken;

public class STSAuditLogger
extends AuditLogger {
    private static final String WS_TRUST = "WSTrust";
    public static final String EVENT_STS = "STS";
    public static final String ROLE_STS = "STS";
    public static final String TOKEN_ISSUE = "TokenIssue";
    public static final String TOKEN_VALIDATE = "TokenValidate";
    public static final String SAML_SUBJECT = "SAML_SUBJECT";
    private static final Log log = LogFactory.getLog(STSAuditLogger.class);

    public static void init() {
        ThreadContext.put((String)AuditLogger.MDC_KEY.EVENT.toString(), (String)"STS");
        STSAuditLogger.setProtocol(WS_TRUST);
    }

    public static void log() {
        STSAuditLogger.updateResponseTime();
        STSAuditLogger.log(log, "");
        STSAuditLogger.checkUpdateTransactionCounters();
    }

    public static void setInMsgCtx(WsTrustInMessageContext inMsgCtx) {
        if (inMsgCtx != null) {
            try {
                if (inMsgCtx.getMaskedXml() != null) {
                    XmlObject xmlObj = inMsgCtx.getMaskedXml();
                    XmlOptions opts = XmlBeansUtil.getXmlOptions();
                    opts.setSavePrettyPrint();
                    String xml = xmlObj.xmlText(opts);
                    if (StringUtils.isNotBlank((String)xml)) {
                        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)xml);
                    }
                }
            }
            catch (WSTrustException wSTrustException) {
                // empty catch block
            }
        }
    }

    public static void setOutMsgCtx(WsTrustOutMessageContext outMsgCtx) {
        if (outMsgCtx != null && outMsgCtx.getMaskedXml() != null) {
            XmlObject xmlObj = outMsgCtx.getMaskedXml();
            XmlOptions opts = XmlBeansUtil.getXmlOptions();
            opts.setSavePrettyPrint();
            String xml = xmlObj.xmlText(opts);
            if (StringUtils.isNotBlank((String)xml)) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)xml);
            }
        }
    }

    public static void setInMsgType(String inMsgType) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)inMsgType);
    }

    public static void setAssertionId(String assertionId) {
        if (StringUtils.isNotBlank((String)assertionId)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        }
    }

    public static void setConnectionId(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)value);
        }
    }

    public static void setConnectionName(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_NAME.toString(), (String)value);
        }
    }

    public static void setVirtualServerId(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.VIRTUAL_SERVER_ID.toString(), (String)value);
        }
    }

    public static void setSTSPluginId(String stsPluginId) {
        if (StringUtils.isNotBlank((String)stsPluginId)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.STS_PLUGIN_ID.toString(), (String)stsPluginId);
        }
    }

    public static void setRole(String role) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)role);
    }

    public static void setAttributes(AttributeMap attributes) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ATTRIBUTES.toString(), (String)STSAuditLogger.getAttributesAsString(attributes));
    }

    public static String getAttributesAsString(AttributeMap attributeMap) {
        LinkedList<String> keyValue = new LinkedList<String>();
        if (attributeMap != null) {
            for (String key : attributeMap.keySet()) {
                keyValue.add(key + "=" + ((AttributeValue)attributeMap.get((Object)key)).sensitiveToString());
            }
        }
        return Util.listToDelimString(keyValue, ",");
    }

    public static void auditInTokenForRst(SecurityToken inToken, RequestSecurityToken rst) {
        if (inToken != null) {
            if (inToken instanceof UsernameToken) {
                UsernameToken usernameToken = (UsernameToken)inToken;
                STSAuditLogger.setUserName(usernameToken.getUsername());
            } else if (inToken instanceof X509SecurityToken) {
                X509SecurityToken x509Token = (X509SecurityToken)inToken;
                STSAuditLogger.setUserName(x509Token.getCertificate().getSubjectDN().getName());
            } else if (inToken instanceof Saml11SecurityToken) {
                Saml11SecurityToken saml11Token = (Saml11SecurityToken)inToken;
                AssertionAssembler saml1xAssembler = new AssertionAssembler();
                AttributeMap attributes = saml1xAssembler.disassemble(saml11Token.getAssertion(), Collections.emptySet());
                STSAuditLogger.setUserName(((AttributeValue)attributes.get((Object)SAML_SUBJECT)).getValue(true));
                if (RequestType.VALIDATE == rst.getRequestType()) {
                    STSAuditLogger.setAssertionId(saml11Token.getId());
                }
            } else if (inToken instanceof Saml20SecurityToken) {
                Saml20SecurityToken saml20Token = (Saml20SecurityToken)inToken;
                org.sourceid.saml20.protocol.AssertionAssembler saml20Assembler = new org.sourceid.saml20.protocol.AssertionAssembler();
                AttributeMap attributes = saml20Assembler.disassemble(saml20Token.getAssertion());
                STSAuditLogger.setUserName(((AttributeValue)attributes.get((Object)SAML_SUBJECT)).getValue(true));
                if (RequestType.VALIDATE == rst.getRequestType()) {
                    STSAuditLogger.setAssertionId(saml20Token.getId());
                }
            }
        }
    }

    public static void auditOutTokenForRst(SecurityToken outToken) {
        if (outToken != null) {
            if (outToken instanceof Saml11SecurityToken) {
                Saml11SecurityToken saml11Token = (Saml11SecurityToken)outToken;
                STSAuditLogger.setAssertionId(saml11Token.getId());
            } else if (outToken instanceof Saml20SecurityToken) {
                Saml20SecurityToken saml20Token = (Saml20SecurityToken)outToken;
                STSAuditLogger.setAssertionId(saml20Token.getId());
            }
        }
    }
}

