/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.configservice.ListenerRegistry;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenPluginManager;
import org.sourceid.wstrust.plugin.process.TokenPluginDescriptor;

public abstract class BaseTokenPluginManager<T extends TokenPluginInstance>
implements TokenPluginManager<T> {
    protected PluginManagementSupport pluginMgmtSupport;

    @Override
    public Collection<TokenPluginDescriptor> getInstalledDescriptors() {
        Collection<PluginDescriptor> descriptors = this.pluginMgmtSupport.getInstalledPluginDescriptors();
        return descriptors;
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<T> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public Collection<T> getNonConnectionBasedInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getNonConnectionBasedPlugins();
        return instances;
    }

    @Override
    public T getInstance(String instanceId) {
        return (T)((TokenPluginInstance)this.pluginMgmtSupport.getPluginInstance(instanceId));
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.savePluginInstance(instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public List<T> getInstancesForTokenType(String tokenType) {
        ArrayList<TokenPluginInstance> instances = new ArrayList<TokenPluginInstance>();
        for (ConfigurablePluginInstance instance : this.getInstances()) {
            if (!tokenType.equals(((TokenPluginInstance)instance).getTokenType())) continue;
            instances.add((TokenPluginInstance)instance);
        }
        return instances;
    }

    @Override
    public T getInstanceForTokenType(String tokenType) {
        for (ConfigurablePluginInstance instance : this.getInstances()) {
            if (!tokenType.equals(((TokenPluginInstance)instance).getTokenType())) continue;
            return (T)((TokenPluginInstance)instance);
        }
        return null;
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        MgmtFactory.getMediator().registerForReloadEvents(reloadable);
        ListenerRegistry.getInstance().addListener(this.getConfigEventType(), reloadable, r -> r.reload());
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public void reload() {
        this.pluginMgmtSupport.clearInstanceCaches();
        ListenerRegistry.getInstance().notifyListeners(this.getConfigEventType());
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return true;
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        for (TokenPluginInstance instance : this.getInstances()) {
            String parentId = instance.getParentId();
            if (parentId == null || !parentId.equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    public PluginManagementSupport getPluginMgmtSupport() {
        return this.pluginMgmtSupport;
    }

    public void setPluginMgmtSupport(PluginManagementSupport pluginMgmtSupport) {
        this.pluginMgmtSupport = pluginMgmtSupport;
    }

    @Override
    public T getInstanceWithConnectionOverride(String instanceId, String connectionId) {
        return (T)((TokenPluginInstance)this.pluginMgmtSupport.getPluginInstanceForConnection(instanceId, connectionId));
    }

    @Override
    public List<T> getCBPOInstances(String instanceId) {
        return this.pluginMgmtSupport.getCBPOInstances(instanceId);
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
        if (this.supportsDefaultInstance()) {
            this.pluginMgmtSupport.setDefaultInstance(pluginId);
        }
    }

    @Override
    public Collection<T> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }

    protected abstract ConfigEventType getConfigEventType();
}

