/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.ConfigurationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementFactory;
import org.sourceid.saml20.domain.mgmt.impl.TokenGeneratorMgmtConfigSupport;
import org.sourceid.wstrust.mgmt.BaseTokenPluginManager;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;

public class TokenGeneratorManagerImpl
extends BaseTokenPluginManager<TokenGeneratorInstance>
implements TokenGeneratorManager,
AutoReloadable {
    public TokenGeneratorManagerImpl() {
        PluginManagementFactory pluginManagementFactory = new PluginManagementFactory();
        this.pluginMgmtSupport = pluginManagementFactory.makeTokenGeneratorMgmtSupport();
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public TokenGenerator getTokenGenerator(String instanceId) {
        return (TokenGenerator)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    @Override
    public void importTokenGeneratorConfiguration(String instanceId, String className, String xml, String parentId, boolean allowUpdate) throws XmlException, ConfigurationException {
        if (this.getTokenGenerator(instanceId) != null && !allowUpdate) {
            throw new ConfigurationException("The token generator instance with id=" + instanceId + " already exists. [allowUpdate=false]");
        }
        TokenGeneratorMgmtConfigSupport tokeGeneratorMgmtConfigSupport = new TokenGeneratorMgmtConfigSupport();
        TokenPluginInstance pluginInstance = tokeGeneratorMgmtConfigSupport.parseXml(xml, className);
        pluginInstance.setId(instanceId);
        pluginInstance.setParentId(parentId);
        this.saveInstance(pluginInstance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return MgmtFactory.getToken2TokenManager().isTargetInUse(pluginId) || MgmtFactory.getProcessorPolicy2TokenGeneratorManager().isTargetInUse(pluginId) || this.getIdpConnectionsUsingId(pluginId).size() > 0 || !MgmtFactory.getTokenExchangeGeneratorPolicyManager().getPoliciesUsingGenerator(pluginId).isEmpty();
    }

    @Override
    public List<IdpConnection> getIdpConnectionsUsingId(String pluginId) {
        Collection<IdpConnection> idpConnections = MgmtFactory.getConnectionManager().getFilteredIdpConnections();
        ArrayList<IdpConnection> idpConns = new ArrayList<IdpConnection>();
        for (IdpConnection idp : idpConnections) {
            if (!idp.doesWsTrustSettingsExist()) continue;
            Set<String> connectionGeneratorIds = idp.getWsTrustSettings().getIncomingTokenGenerators();
            for (String connectionGeneratorId : connectionGeneratorIds) {
                if (!connectionGeneratorId.equals(pluginId)) continue;
                idpConns.add(idp);
            }
        }
        return idpConns;
    }

    @Override
    public TokenGeneratorInstance newInstance() {
        return new TokenGeneratorInstance();
    }

    @Override
    public TokenGeneratorInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void reloadConnBasedPluginOverrides(ConnectionBase conn) {
        if (conn instanceof IdpConnection) {
            this.pluginMgmtSupport.reloadConnBasedInstances(conn);
        }
    }

    @Override
    public void removeConnBasedPluginOverrides(ConnectionBase conn) {
        if (conn instanceof IdpConnection) {
            this.pluginMgmtSupport.removeConnBasedInstances(conn);
        }
    }

    @Override
    protected ConfigEventType getConfigEventType() {
        return ConfigEventType.TOKEN_GENERATORS_RELOADED;
    }
}

