/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.crypto.HashedPassword;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.common.ByteUtil;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.wstrust.mgmt.WsTrustBasicAuthManager;
import org.sourceid.wstrust.model.BasicAuthUser;

public class WsTrustBasicAuthManagerImpl
implements WsTrustBasicAuthManager,
AutoReloadable {
    private static final String CONFIG_NAME = "wstrust-basic-auth";
    private static final String CREDENTIALS = "credentials";
    private static final String ENABLED = "enabled";
    private ConfigStore configStore;
    private volatile Map<String, String> credentials = Collections.emptyMap();

    public WsTrustBasicAuthManagerImpl() {
        this.configStore = ConfigStoreFarm.getConfig(CONFIG_NAME);
        this.credentials = this.configStore.getMapValue(CREDENTIALS, Collections.emptyMap());
    }

    @Override
    public boolean isAuthenticationEnabled() {
        return this.configStore.getBooleanValue(ENABLED, false);
    }

    @Override
    public void setAuthenticationEnabled(boolean enabled) {
        this.configStore.setBooleanValue(ENABLED, enabled);
    }

    @Override
    public boolean authenticate(String id, String sharedSecret) {
        String encodedVal;
        if (id != null && sharedSecret != null && (encodedVal = this.credentials.get(id)) != null) {
            if (HashedPassword.isEncodedText(encodedVal)) {
                HashedPassword hashedPassword = HashedPassword.fromEncodedText(encodedVal);
                return hashedPassword.checkSecret(sharedSecret);
            }
            String expectedSecretVal = Obfuscator.deobfuscate(encodedVal);
            byte[] sharedSecretBytes = sharedSecret.getBytes(Util.UTF8CS);
            byte[] expectedSharedSecretBytes = expectedSecretVal.getBytes(Util.UTF8CS);
            return ByteUtil.secureEquals(sharedSecretBytes, expectedSharedSecretBytes);
        }
        return false;
    }

    @Override
    public void setCredentials(Map<String, String> credentials) {
        HashMap<String, String> hashedCreds = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : credentials.entrySet()) {
            String username = entry.getKey();
            String newPassword = entry.getValue();
            if (username == null) {
                throw new IllegalArgumentException("One of the ids is null");
            }
            if (newPassword == null) {
                String currentPassword = this.credentials.get(username);
                if (!HashedPassword.isEncodedText(currentPassword)) {
                    String clearPassword = Obfuscator.deobfuscate(currentPassword);
                    currentPassword = HashedPassword.fromClearText(clearPassword).toEncodedText();
                }
                hashedCreds.put(username, currentPassword);
                continue;
            }
            if (HashedPassword.isEncodedText(newPassword)) {
                hashedCreds.put(username, newPassword);
                continue;
            }
            hashedCreds.put(username, HashedPassword.fromClearText(newPassword).toEncodedText());
        }
        this.configStore.setMapValue(CREDENTIALS, hashedCreds);
        this.credentials = hashedCreds;
    }

    @Override
    public Set<String> getIds() {
        return this.configStore.getMapValue(CREDENTIALS, Collections.EMPTY_MAP).keySet();
    }

    @Override
    public List<BasicAuthUser> getUsers() {
        return this.credentials.entrySet().stream().map(entry -> {
            BasicAuthUser user = new BasicAuthUser();
            user.setUsername((String)entry.getKey());
            user.setEncryptedPassword((String)entry.getValue());
            return user;
        }).collect(Collectors.toList());
    }

    @Override
    public void setUsers(List<BasicAuthUser> users) {
        this.setCredentials(users.stream().collect(Collectors.toMap(BasicAuthUser::getUsername, BasicAuthUser::getEncryptedPassword)));
    }
}

