/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.crypto.Cert;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.impl.ServerX509TrustManager;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;
import org.sourceid.wstrust.mgmt.X509DistinguishedNameFilter;
import org.sourceid.wstrust.mgmt.X509IssuerFilter;

public class WsTrustClientCertAuthManagerImpl
implements WsTrustClientCertAuthManager,
AutoReloadable {
    private static final String CONFIG_NAME = "wstrust-client-cert-auth";
    private static final String RESTRICT_BY_SUBJECT_DN = "restrict-by-subject-dn";
    private static final String ISSUER_DN_LIST_NAME = "acceptable-issuer-cert-aliases";
    private static final String SUBJECT_DN_LIST_NAME = "acceptable-subject-DNs";
    private ConfigStore configStore;
    protected Log log = LogFactory.getLog(this.getClass());
    private X509DistinguishedNameFilter subjectFilter = new X509DistinguishedNameFilter();
    private X509IssuerFilter issuerFilter = new X509IssuerFilter();
    PkCertAndConnectionCertManager certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();

    public WsTrustClientCertAuthManagerImpl() {
        this.configStore = ConfigStoreFarm.getConfig(CONFIG_NAME);
        this.init();
    }

    private synchronized void init() {
        if (this.configStore.getBooleanValue("enabled", false) && this.configStore.getBooleanValue("restrict-by-issuer-cert", false)) {
            this.issuerFilter = new X509IssuerFilter(new ArrayList<String>(this.configStore.getListValue(ISSUER_DN_LIST_NAME, new ArrayList<String>())));
        }
        if (this.configStore.getBooleanValue("enabled", false) && this.configStore.getBooleanValue(RESTRICT_BY_SUBJECT_DN, false)) {
            this.subjectFilter = new X509DistinguishedNameFilter(new ArrayList<String>(this.configStore.getListValue(SUBJECT_DN_LIST_NAME, new ArrayList<String>())));
        }
    }

    @Override
    public synchronized boolean isRestrictBySubjectDn() {
        return this.configStore.getBooleanValue(RESTRICT_BY_SUBJECT_DN, false);
    }

    @Override
    public synchronized void setRestrictBySubjectDn(boolean restrictBySubjectDn) {
        this.configStore.setBooleanValue(RESTRICT_BY_SUBJECT_DN, restrictBySubjectDn);
    }

    @Override
    public synchronized boolean isRestrictByIssuerCert() {
        return this.configStore.getBooleanValue("restrict-by-issuer-cert", false);
    }

    @Override
    public synchronized void setRestrictByIssuerCert(boolean restrictByIssuerCert) {
        this.configStore.setBooleanValue("restrict-by-issuer-cert", restrictByIssuerCert);
        this.refreshTrustManager();
    }

    @Override
    public synchronized List<String> getAcceptableSubjectDnList() {
        return this.configStore.getListValue(SUBJECT_DN_LIST_NAME, new ArrayList<String>());
    }

    @Override
    public synchronized void setAcceptableSubjectDnList(List<String> acceptableSubjectDnList) {
        this.configStore.setListValue(SUBJECT_DN_LIST_NAME, acceptableSubjectDnList);
        this.subjectFilter.setDistinguishedNames(this.getAcceptableSubjectDnList());
    }

    @Override
    public synchronized List<String> getAcceptableIssuerCertAliases() {
        return this.configStore.getListValue(ISSUER_DN_LIST_NAME, new ArrayList<String>());
    }

    @Override
    public synchronized void setAcceptableIssuerCertAliases(List<String> acceptableIssuerCertAliasList) {
        this.configStore.setListValue(ISSUER_DN_LIST_NAME, acceptableIssuerCertAliasList);
        this.issuerFilter.setAliases(this.getAcceptableIssuerCertAliases());
        this.refreshTrustManager();
    }

    @Override
    public synchronized Set<Cert> getCerts() {
        return this.certManager.getCertsForFeature("STS Settings Mutual SSL Authentication Certs");
    }

    @Override
    public synchronized Set<Cert> getCertsInUse() {
        HashSet<Cert> certsInUse = new HashSet<Cert>();
        Set<Cert> certs = this.getCerts();
        HashSet<String> aliasesInUse = new HashSet<String>(this.getAcceptableIssuerCertAliases());
        for (Cert cert : certs) {
            if (!aliasesInUse.contains(cert.getId())) continue;
            certsInUse.add(cert);
        }
        return certsInUse;
    }

    @Override
    public synchronized void saveCerts(Set<Cert> certs) {
        this.certManager.saveCertsForFeature(certs, "STS Settings Mutual SSL Authentication Certs");
    }

    @Override
    public synchronized boolean deleteCertById(String id) {
        boolean certDeleted = false;
        Set<Cert> certs = this.getCerts();
        Iterator<Cert> iterator = certs.iterator();
        while (iterator.hasNext()) {
            Cert cert = iterator.next();
            if (!StringUtils.equals((CharSequence)cert.getId(), (CharSequence)id)) continue;
            iterator.remove();
            certDeleted = true;
        }
        this.saveCerts(certs);
        return certDeleted;
    }

    @Override
    public synchronized Cert getCertById(String id) {
        Cert cert = null;
        try {
            cert = this.certManager.getCert(id);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return cert;
    }

    @Override
    public synchronized boolean isAuthenticationEnabled() {
        return this.configStore.getBooleanValue("enabled", false);
    }

    @Override
    public synchronized boolean isIssuerAcceptable(X509Certificate[] clientCerts) {
        if (this.isRestrictByIssuerCert()) {
            return this.issuerFilter.isIssuerAcceptable(clientCerts);
        }
        return true;
    }

    @Override
    public synchronized boolean isSubjectDnAcceptable(X509Certificate[] clientCerts) {
        if (this.isRestrictBySubjectDn()) {
            return this.subjectFilter.isDistinguishedNameAcceptable(clientCerts[0].getSubjectX500Principal());
        }
        return true;
    }

    @Override
    public synchronized X509Certificate[] getExtendedCertificateChain(X509Certificate[] clientCerts) {
        return this.issuerFilter.findExtendedCertificateChain(clientCerts);
    }

    @Override
    public synchronized void setAuthenticationEnabled(boolean enabled) {
        this.configStore.setBooleanValue("enabled", enabled);
        this.refreshTrustManager();
    }

    private synchronized void refreshTrustManager() {
        ServerX509TrustManager.getX509TrustManager().reload();
    }

    @Override
    public synchronized Set<X509Certificate> getSslAuthCerts() {
        HashSet<X509Certificate> sslAuthCerts = new HashSet<X509Certificate>();
        for (String certificateAlias : this.getAcceptableIssuerCertAliases()) {
            Cert cert = null;
            try {
                cert = this.certManager.getCert(certificateAlias);
            }
            catch (IllegalArgumentException e) {
                this.log.debug((Object)("Error loading certificate alias '" + certificateAlias + "' from keystore '" + this.certManager + "'"));
                continue;
            }
            if (cert == null) continue;
            sslAuthCerts.add(cert.getX509Certificate());
        }
        return sslAuthCerts;
    }
}

