/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.pingcommons.crypto.X500PrincipalWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class X509DistinguishedNameFilter {
    protected Log log = LogFactory.getLog(this.getClass());
    private Set<X500PrincipalWrapper> acceptableDistinguishedNames = new HashSet<X500PrincipalWrapper>();

    public X509DistinguishedNameFilter() {
    }

    public X509DistinguishedNameFilter(List<String> distinguishedNames) {
        this.setDistinguishedNames(distinguishedNames);
    }

    public void setDistinguishedNames(List<String> distinguishedNames) {
        this.acceptableDistinguishedNames.clear();
        for (String dn : distinguishedNames) {
            this.acceptableDistinguishedNames.add(new X500PrincipalWrapper(new X500Principal(dn)));
        }
    }

    public boolean isDistinguishedNameAcceptable(X500Principal principal) {
        if (this.acceptableDistinguishedNames.isEmpty()) {
            return true;
        }
        boolean isAcceptable = this.acceptableDistinguishedNames.contains(new X500PrincipalWrapper(principal));
        if (!isAcceptable && this.log.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(principal.toString());
            sb.append(" is not an acceptable Distinguished Name (DN).  Acceptable DNs are:");
            for (X500PrincipalWrapper p : this.acceptableDistinguishedNames) {
                sb.append(System.getProperty("line.separator", "\n")).append("   ").append(p.getPrincipal().getName());
            }
            this.log.warn((Object)sb);
        }
        return isAcceptable;
    }
}

