/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.X509CertPathValidatorSupport;
import java.security.cert.CertPathValidatorException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class X509IssuerFilter {
    Map<X500Principal, List<X509Certificate>> dnToTrustedCAs = new HashMap<X500Principal, List<X509Certificate>>();
    LinkedHashSet<X509Certificate> trustedCAs = new LinkedHashSet();
    ArrayList<String> aliases = new ArrayList();
    TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
    PkCertAndConnectionCertManager pkCertAndConnectionCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
    protected Log log = LogFactory.getLog(this.getClass());

    public X509IssuerFilter() {
    }

    public X509IssuerFilter(ArrayList<String> aliases) {
        this.aliases = aliases;
        this.configure();
    }

    public boolean isIssuerAcceptable(X509Certificate[] clientCerts) {
        X509CertPathValidatorSupport pathValidator = new X509CertPathValidatorSupport(clientCerts, false);
        pathValidator.addTrustAnchors((Collection<X509Certificate>)this.trustedCAs);
        pathValidator.pruneCertChain();
        try {
            pathValidator.validate();
        }
        catch (CertPathValidatorException e) {
            this.log.debug((Object)"An error occured validating the path of the provided certificate: ", (Throwable)e);
            X509Certificate rootCert = clientCerts[clientCerts.length - 1];
            X500Principal issuerX500Principal = rootCert.getIssuerX500Principal();
            StringBuilder sb = new StringBuilder();
            sb.append(issuerX500Principal.toString());
            sb.append(" is not an acceptable root issuer.  Acceptable issuers are:");
            for (X509Certificate p : this.trustedCAs) {
                sb.append(System.getProperty("line.separator", "\n")).append("   ").append(p.getSubjectX500Principal().getName());
            }
            this.log.warn((Object)sb);
            return false;
        }
        return true;
    }

    public void setAliases(List<String> aliases) {
        this.dnToTrustedCAs.clear();
        this.trustedCAs.clear();
        this.aliases.clear();
        this.aliases.addAll(aliases);
        this.configure();
    }

    void setTrustedCAsManager(TrustedCAsManager trustedCAsManager) {
        this.trustedCAsManager = trustedCAsManager;
    }

    public void setPkCertAndConnectionCertManager(PkCertAndConnectionCertManager pkCertAndConnectionCertManager) {
        this.pkCertAndConnectionCertManager = pkCertAndConnectionCertManager;
    }

    private void configure() {
        for (String alias : this.aliases) {
            Cert caCert = null;
            try {
                caCert = this.pkCertAndConnectionCertManager.getCert(alias);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (caCert == null) continue;
            this.addCertToTrustedCAs(caCert.getX509Certificate());
        }
        if (this.trustedCAs.isEmpty() && this.aliases.isEmpty()) {
            for (X509Certificate x509Cert : this.trustedCAsManager.getTrustedCaX509s()) {
                this.addCertToTrustedCAs(x509Cert);
            }
        }
    }

    private void addCertToTrustedCAs(X509Certificate x509Cert) {
        X500Principal x500Principal = x509Cert.getSubjectX500Principal();
        List<X509Certificate> x509Certs = this.dnToTrustedCAs.get(x500Principal);
        if (x509Certs == null) {
            x509Certs = new ArrayList<X509Certificate>(1);
            this.dnToTrustedCAs.put(x500Principal, x509Certs);
        }
        this.trustedCAs.add(x509Cert);
        x509Certs.add(x509Cert);
    }

    public X509Certificate[] findExtendedCertificateChain(X509Certificate[] clientCerts) {
        if (clientCerts.length == 0) {
            return null;
        }
        for (X509Certificate cert : clientCerts) {
            if (!this.trustedCAs.contains(cert)) continue;
            return clientCerts;
        }
        X509Certificate lastCert = clientCerts[clientCerts.length - 1];
        X500Principal issuerPrincipal = lastCert.getIssuerX500Principal();
        List<X509Certificate> issuerCerts = this.dnToTrustedCAs.get(issuerPrincipal);
        if (issuerCerts != null) {
            int newLength = clientCerts.length + 1;
            X509Certificate[] extendedChain = Arrays.copyOf(clientCerts, newLength);
            if (issuerCerts.size() == 1) {
                extendedChain[newLength - 1] = issuerCerts.get(0);
                return extendedChain;
            }
            List<X509Certificate> clientCertList = Arrays.asList(clientCerts);
            for (X509Certificate issuerCert : issuerCerts) {
                if (!X509CertPathValidatorSupport.isValid(clientCertList, Collections.singleton(new TrustAnchor(issuerCert, null)))) continue;
                extendedChain[newLength - 1] = issuerCert;
                return extendedChain;
            }
        }
        return null;
    }
}

