/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.x2009.x05.stsRequestcontract.AttributeType;
import com.pingidentity.x2009.x05.stsRequestcontract.RequestContractType;
import com.pingidentity.x2009.x05.stsRequestcontract.RequestContractsDocument;
import com.pingidentity.x2009.x05.stsRequestcontract.RequestContractsType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class WsTrustRequestContractManagerImpl
implements WsTrustRequestContractManager,
AutoReloadable {
    public static final String DATA_FILE = "pingfederate-sts-request-contracts.xml";
    private SysDirInfo dirInfo;
    private XmlLoader loader;
    private Map<String, WsTrustRequestContract> contractsById;

    public WsTrustRequestContractManagerImpl(XmlLoader loader, SysDirInfo dirInfo) {
        this.loader = loader;
        this.dirInfo = dirInfo;
        this.loadConfig();
    }

    @Override
    public synchronized WsTrustRequestContract findById(String id) {
        return this.contractsById.get(id);
    }

    @Override
    public synchronized Collection<WsTrustRequestContract> findAll() {
        return this.contractsById.values();
    }

    @Override
    public synchronized void store(WsTrustRequestContract contract) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            contract.setLastModified((Calendar)new XmlCalendar(new Date()));
            WsTrustRequestContract existing = this.contractsById.put(contract.getId(), contract);
            this.save();
            auditLoggerScope.log(AdminAuditLogger.Component.STS_REQUEST_PARAM, existing == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized void storeAll(Collection<WsTrustRequestContract> contracts) {
        this.contractsById = new HashMap<String, WsTrustRequestContract>();
        for (WsTrustRequestContract contract : contracts) {
            this.contractsById.put(contract.getId(), contract);
        }
        this.save();
    }

    @Override
    public synchronized void delete(WsTrustRequestContract contract) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            if (this.contractsById.remove(contract.getId()) != null) {
                this.save();
            }
            auditLoggerScope.log(AdminAuditLogger.Component.STS_REQUEST_PARAM, AdminAuditLogger.Event.DELETE);
        }
    }

    private void save() {
        RequestContractsDocument doc = this.marshall();
        this.loader.save(this.dirInfo.getDataDirectory(), DATA_FILE, (XmlObject)doc);
        this.loadConfig();
    }

    private RequestContractsDocument marshall() {
        RequestContractsDocument doc = RequestContractsDocument.Factory.newInstance();
        RequestContractsType xContracts = doc.addNewRequestContracts();
        for (WsTrustRequestContract contract : this.contractsById.values()) {
            RequestContractType xConract = xContracts.addNewRequestContract();
            this.marshall(contract, xConract);
        }
        return doc;
    }

    private void marshall(WsTrustRequestContract contract, RequestContractType xConract) {
        xConract.setId(contract.getId());
        xConract.setName(contract.getName());
        if (contract.getLastModified() != null) {
            xConract.setLastModified(contract.getLastModified());
        }
        for (String name : contract.getMutableAttributeNames()) {
            xConract.addNewAttribute().addNewAttributeName().setStringValue(name);
        }
    }

    private void loadConfig() {
        RequestContractType[] contracts;
        this.contractsById = new HashMap<String, WsTrustRequestContract>();
        String dataDir = this.dirInfo.getDataDirectory();
        RequestContractsDocument doc = (RequestContractsDocument)this.loader.load(dataDir, DATA_FILE);
        for (RequestContractType contract : contracts = doc.getRequestContracts().getRequestContractArray()) {
            WsTrustRequestContract wsTrustContract = this.unmarshall(contract);
            this.contractsById.put(wsTrustContract.getId(), wsTrustContract);
        }
    }

    private WsTrustRequestContract unmarshall(RequestContractType xContract) {
        AttributeType[] attributes;
        WsTrustRequestContract result = new WsTrustRequestContract();
        result.setId(xContract.getId());
        result.setName(xContract.getName());
        if (xContract.isSetLastModified()) {
            result.setLastModified(xContract.getLastModified());
        }
        for (AttributeType attribute : attributes = xContract.getAttributeArray()) {
            result.addMutableAttributeName(attribute.getAttributeName().getStringValue());
        }
        return result;
    }
}

