/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.WSTrustVersionInfo;
import org.sourceid.wstrust.protocol.v13.WSTrust13VersionInfo;
import org.sourceid.wstrust.protocol.v2005.WSTrust2005VersionInfo;

public enum ActionType {
    ISSUE(WSTrust13VersionInfo.ISSUE_ACTION_RST, WSTrust13VersionInfo.ISSUE_ACTION_RSTR, WSTrust13VersionInfo.ISSUE_ACTION_RSTR_FINAL, WSTrust2005VersionInfo.ISSUE_ACTION_RST, WSTrust2005VersionInfo.ISSUE_ACTION_RSTR),
    VALIDATE(WSTrust13VersionInfo.VALIDATE_ACTION_RST, WSTrust13VersionInfo.VALIDATE_ACTION_RSTR, WSTrust13VersionInfo.VALIDATE_ACTION_RSTR_FINAL, WSTrust2005VersionInfo.VALIDATE_ACTION_RST, WSTrust2005VersionInfo.VALIDATE_ACTION_RSTR);

    private List<WSTrustVersionInfo> uris = new ArrayList<WSTrustVersionInfo>();

    private ActionType(WSTrustVersionInfo ... uris) {
        this.uris.addAll(Arrays.asList(uris));
    }

    public static ActionType fromUri(String uri) {
        for (ActionType type : ActionType.values()) {
            for (WSTrustVersionInfo versionInfo : type.uris) {
                if (!versionInfo.getUri().equals(uri)) continue;
                return type;
            }
        }
        return null;
    }

    public static WSTrustVersion getVersionFromUri(String uri) {
        for (ActionType type : ActionType.values()) {
            for (WSTrustVersionInfo versionInfo : type.uris) {
                if (!versionInfo.getUri().equals(uri)) continue;
                return versionInfo.getVersion();
            }
        }
        return null;
    }
}

