/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import com.pingidentity.common.util.B64;
import java.util.Date;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class BinarySecurityToken
implements SecurityToken {
    public static final String BASE64_ENCODING_TYPE = WsTrustTokenType.BINARY.getUri();
    public static final String BASE64_URL_ENCODING_TYPE = "http://tools.ietf.org/rfc/rfc4648.txt#base64url";
    private String id;
    private String type;
    private String encodedData;
    private String encodingType;
    private Date createdDate = null;
    private Date expiryDate = null;

    public BinarySecurityToken(String id, String type) {
        this.id = id;
        this.type = type;
    }

    public BinarySecurityToken(String type) {
        this(null, type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdDate == null ? 0 : this.createdDate.hashCode());
        result = 31 * result + (this.encodedData == null ? 0 : this.encodedData.hashCode());
        result = 31 * result + (this.encodingType == null ? 0 : this.encodingType.hashCode());
        result = 31 * result + (this.expiryDate == null ? 0 : this.expiryDate.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinarySecurityToken other = (BinarySecurityToken)obj;
        if (this.createdDate == null ? other.createdDate != null : !this.createdDate.equals(other.createdDate)) {
            return false;
        }
        if (this.encodedData == null ? other.encodedData != null : !this.encodedData.equals(other.encodedData)) {
            return false;
        }
        if (this.encodingType == null ? other.encodingType != null : !this.encodingType.equals(other.encodingType)) {
            return false;
        }
        if (this.expiryDate == null ? other.expiryDate != null : !this.expiryDate.equals(other.expiryDate)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setEncodedData(String encodedData) {
        this.encodedData = encodedData;
    }

    public String getEncodedData() {
        return this.encodedData;
    }

    public byte[] getDecodedData() {
        if (this.getEncodingType() != null && !this.getEncodingType().equals(BASE64_ENCODING_TYPE)) {
            throw new ProcessRuntimeException("Unsupported encoding type " + this.getEncodingType());
        }
        return B64.decodeToBytes((String)this.encodedData);
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }
}

