/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import com.pingidentity.common.util.B64;
import com.pingidentity.pingcommons.mask.JwtMasker;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecuritySecext10.BinarySecurityTokenType;
import org.sourceid.util.log.internal.Masker;

public class BinarySecurityTokenJwtMasker
implements Masker {
    private static final Log LOG = LogFactory.getLog(BinarySecurityTokenJwtMasker.class);
    private static final String XPATH_BINARY_TOKEN = "declare namespace wsse='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' .//wsse:BinarySecurityToken";

    @Override
    public XmlObject mask(XmlObject srcXmlObj, Set<String> maskedAttrNames) {
        XmlObject[] bsts;
        if (maskedAttrNames == null) {
            maskedAttrNames = new HashSet<String>();
        }
        XmlObject copy = srcXmlObj.copy();
        for (XmlObject bst : bsts = copy.selectPath(XPATH_BINARY_TOKEN)) {
            BinarySecurityTokenType bstType = (BinarySecurityTokenType)bst;
            String encodedJwt = bstType.getStringValue();
            String jwt = B64.decodeToString((String)encodedJwt);
            JwtMasker jwtMasker = new JwtMasker();
            try {
                jwt = jwtMasker.mask(jwt, maskedAttrNames);
            }
            catch (InvalidJwtException e) {
                LOG.warn((Object)"Unable to mask invalid JWT.");
            }
            bstType.setStringValue(B64.encode((String)jwt));
        }
        return copy;
    }
}

