/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.WSTrustVersionInfo;

public enum KeyType {
    Symmetric("/SymmetricKey", WSTrustVersion.v13.getDocumentNamespace(), WSTrustVersion.v2005.getDocumentNamespace()),
    Asymmetric("/AsymmetricKey", WSTrustVersion.v13.getDocumentNamespace(), WSTrustVersion.v2005.getDocumentNamespace()),
    Bearer("/Bearer", WSTrustVersion.v13.getDocumentNamespace(), WSTrustVersion.v2005.getDocumentNamespace()),
    Nonce("/Nonce", WSTrustVersion.v13.getDocumentNamespace(), WSTrustVersion.v2005.getDocumentNamespace()),
    NoProof("http://schemas.xmlsoap.org/ws/2005/05/identity/NoProofKey");

    private boolean namespaceDependent;
    private String keyType;
    private List<WSTrustVersionInfo> versions;

    private KeyType(String keyTypeValue) {
        this.keyType = keyTypeValue;
        this.namespaceDependent = false;
    }

    private KeyType(String suffix, WSTrustVersionInfo ... versions) {
        this.keyType = suffix;
        this.namespaceDependent = true;
        this.versions = new ArrayList<WSTrustVersionInfo>();
        this.versions.addAll(Arrays.asList(versions));
    }

    public String toUri(WSTrustVersion version) {
        if (this.namespaceDependent) {
            return version.getDocumentNamespace().getUri() + this.keyType;
        }
        return this.keyType;
    }

    public static KeyType fromUri(String uri) throws IllegalArgumentException {
        for (KeyType type : KeyType.values()) {
            if (type.namespaceDependent) {
                for (WSTrustVersionInfo versionInfo : type.versions) {
                    if (!(versionInfo.getUri() + type.keyType).equals(uri)) continue;
                    return type;
                }
                continue;
            }
            if (!type.keyType.equals(uri)) continue;
            return type;
        }
        return null;
    }
}

