/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.protocol.WSTrustVersionInfo;
import org.sourceid.wstrust.protocol.v13.WSTrust13VersionInfo;
import org.sourceid.wstrust.protocol.v2005.WSTrust2005VersionInfo;

public enum RequestType {
    ISSUE(WSTrust13VersionInfo.ISSUE, WSTrust2005VersionInfo.ISSUE),
    VALIDATE(WSTrust13VersionInfo.VALIDATE, WSTrust2005VersionInfo.VALIDATE);

    private List<WSTrustVersionInfo> uris = new ArrayList<WSTrustVersionInfo>();

    private RequestType(WSTrustVersionInfo ... uris) {
        this.uris.addAll(Arrays.asList(uris));
    }

    public static RequestType fromUri(String uri) {
        for (RequestType type : RequestType.values()) {
            for (WSTrustVersionInfo versionInfo : type.uris) {
                if (!versionInfo.getUri().equals(uri)) continue;
                return type;
            }
        }
        throw new WSTrustException("Unsupported request type: " + uri);
    }
}

