/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.Date;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class Saml11O365SecurityToken
extends SamlSecurityToken {
    public static final String TYPE = WsTrustTokenType.SAML11O365.getUri();
    public static final String ID_TYPE_URI = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    private AssertionType assertion;
    public static final String SAML11O365_ASSERTION = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String SAML11O365_SECURITY_TOKEN_REF_TOKEN_ATTR = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";

    public String getId() {
        return this.assertion.getAssertionID();
    }

    @Override
    public String getIssuer() {
        return this.assertion.getIssuer();
    }

    public String getType() {
        return TYPE;
    }

    public AssertionType getAssertion() {
        return this.assertion;
    }

    public void setAssertion(AssertionType assertion) {
        this.assertion = assertion;
    }

    public String toString() {
        return "Saml11O365SecurityToken{assertion=" + this.assertion + "}";
    }

    public Date getCreatedDate() {
        return this.assertion.getIssueInstant().getTime();
    }

    public Date getExpiryDate() {
        return this.assertion.getConditions().getNotOnOrAfter().getTime();
    }

    @Override
    public String getIdentifierTypeUri() {
        return ID_TYPE_URI;
    }
}

