/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.Date;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class Saml11SecurityToken
extends SamlSecurityToken {
    public static final String TYPE = WsTrustTokenType.SAML11.getUri();
    public static final String ID_TYPE_URI = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    private AssertionType assertion;

    public String getId() {
        return this.assertion.getAssertionID();
    }

    @Override
    public String getIssuer() {
        return this.assertion.getIssuer();
    }

    public String getType() {
        return TYPE;
    }

    public AssertionType getAssertion() {
        return this.assertion;
    }

    public void setAssertion(AssertionType assertion) {
        this.assertion = assertion;
    }

    public String toString() {
        return "Saml11SecurityToken{assertion=" + this.assertion + "}";
    }

    public Date getCreatedDate() {
        return this.assertion.getIssueInstant().getTime();
    }

    public Date getExpiryDate() {
        return this.assertion.getConditions().getNotOnOrAfter().getTime();
    }

    @Override
    public String getIdentifierTypeUri() {
        return ID_TYPE_URI;
    }
}

