/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.Date;
import org.sourceid.saml20.protocol.AssertionTypeUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class Saml20SecurityToken
extends SamlSecurityToken {
    private static final AssertionTypeUtil assertionTypeUtil = new AssertionTypeUtil();
    public static final String TYPE = WsTrustTokenType.SAML20.getUri();
    public static final String ID_TYPE_URI = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
    private AssertionType assertion;

    public String getId() {
        return this.assertion.getID();
    }

    @Override
    public String getIssuer() {
        return assertionTypeUtil.getIssuer(this.assertion);
    }

    public String getType() {
        return TYPE;
    }

    public void setAssertion(AssertionType assertion) {
        this.assertion = assertion;
    }

    public AssertionType getAssertion() {
        return this.assertion;
    }

    public Date getCreatedDate() {
        return this.assertion.getIssueInstant().getTime();
    }

    public Date getExpiryDate() {
        return this.assertion.getConditions().getNotOnOrAfter().getTime();
    }

    @Override
    public String getIdentifierTypeUri() {
        return ID_TYPE_URI;
    }
}

