/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.Signature;
import org.sourceid.wstrust.model.Timestamp;

public class SoapHeaders {
    private String messageId;
    private String messageIdNamespaceURI;
    private String RelatesTo;
    private String To;
    private String action;
    private String actionNamespaceURI;
    private Timestamp timestamp;
    private final Set<SecurityToken> tokens = new HashSet<SecurityToken>(4);
    private Signature signature;

    public String getTo() {
        return this.To;
    }

    public void setTo(String to) {
        this.To = to;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public String getRelatesTo() {
        return this.RelatesTo;
    }

    public void setRelatesTo(String relatesTo) {
        this.RelatesTo = relatesTo;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageIdNamespaceURI() {
        return this.messageIdNamespaceURI;
    }

    public String setMessageIdNamespaceURI(String URI2) {
        this.messageIdNamespaceURI = URI2;
        return this.messageIdNamespaceURI;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getActionNamespaceURI() {
        return this.actionNamespaceURI;
    }

    public void setActionNamespaceURI(String URI2) {
        this.actionNamespaceURI = URI2;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public int getNoOfSecurityTokens() {
        return this.tokens.size();
    }

    public SecurityToken getTokenById(String requestedTokenId) {
        SecurityToken securityToken = null;
        if (requestedTokenId != null) {
            for (SecurityToken token : this.tokens) {
                if (!requestedTokenId.equals(token.getId())) continue;
                securityToken = token;
                break;
            }
        }
        return securityToken;
    }

    public SecurityToken getFirstToken() {
        return this.tokens.iterator().next();
    }

    public Collection<SecurityToken> getAllTokens() {
        return this.tokens;
    }

    public String toString() {
        return "SoapHeaders{messageId='" + this.messageId + "', RelatesTo='" + this.RelatesTo + "', action=" + this.action + ", timestamp=" + this.timestamp + ", tokens=" + this.tokens + "}";
    }

    public void addSecurityToken(SecurityToken token) {
        this.tokens.add(token);
    }

    public void addSecurityTokens(List<SecurityToken> tokenList) {
        for (SecurityToken securityToken : tokenList) {
            this.addSecurityToken(securityToken);
        }
    }
}

