/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecurityUtility10.AttributedDateTime;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecurityUtility10.CreatedDocument;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecurityUtility10.ExpiresDocument;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecurityUtility10.TimestampDocument;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecurityUtility10.TimestampType;
import org.sourceid.common.Util;
import org.sourceid.wstrust.model.mapper.XmlMappingException;

public class Timestamp {
    private Date created;
    private Date expires;
    private String id;
    private static final String UTC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public Timestamp() {
    }

    public Timestamp(XmlObject xmlObject) {
        this.setXmlObject(xmlObject);
    }

    public Timestamp(String id, Date created, Date expires) {
        this.created = created;
        this.expires = expires;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public void setXmlObject(XmlObject xmlObject) {
        TimestampType timeStampType;
        if (xmlObject instanceof TimestampDocument) {
            timeStampType = ((TimestampDocument)xmlObject).getTimestamp();
        } else if (xmlObject instanceof TimestampType) {
            timeStampType = (TimestampType)xmlObject;
        } else {
            throw new XmlMappingException("given xmlObject is not a supported type");
        }
        this.id = timeStampType.getId();
        this.expires = timeStampType.getExpires() == null ? null : this.parse(timeStampType.getExpires().getStringValue());
        this.created = timeStampType.getCreated() == null ? null : this.parse(timeStampType.getCreated().getStringValue());
    }

    public TimestampDocument build() {
        TimestampDocument timeStampDoc = TimestampDocument.Factory.newInstance();
        TimestampType timeStampType = timeStampDoc.addNewTimestamp();
        timeStampType.setId(this.id);
        if (this.created != null) {
            AttributedDateTime created = AttributedDateTime.Factory.newInstance();
            created.setStringValue(this.format(this.created));
            timeStampType.setCreated(created);
        }
        if (this.expires != null) {
            AttributedDateTime expires = AttributedDateTime.Factory.newInstance();
            expires.setStringValue(this.format(this.expires));
            timeStampType.setExpires(expires);
        }
        return timeStampDoc;
    }

    public CreatedDocument buildCreatedDocument() {
        CreatedDocument createdDocument = CreatedDocument.Factory.newInstance();
        AttributedDateTime created = createdDocument.addNewCreated();
        created.setStringValue(this.format(this.created));
        return createdDocument;
    }

    public ExpiresDocument buildExpiresDocument() {
        ExpiresDocument expiresDocument = ExpiresDocument.Factory.newInstance();
        AttributedDateTime created = expiresDocument.addNewExpires();
        created.setStringValue(this.format(this.expires));
        return expiresDocument;
    }

    private Date parse(String date) {
        try {
            Calendar calander = DatatypeConverter.parseDateTime((String)date);
            if (calander != null) {
                return calander.getTime();
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new XmlMappingException(String.format("Unable to parse timestamp:%s", date));
        }
    }

    private String format(Date date) {
        SimpleDateFormat zulu = new SimpleDateFormat(UTC_FORMAT);
        zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        return zulu.format(date);
    }

    public boolean isExpired(int tolerance, Date date) {
        Calendar nowMinusTolerence = Util.getUtcCalendar();
        nowMinusTolerence.setTime(date);
        nowMinusTolerence.add(12, -tolerance);
        return this.expires != null && this.expires.before(nowMinusTolerence.getTime());
    }

    public boolean isInFuture(int tolerance, Date date) {
        Calendar nowPlusTolerence = Util.getUtcCalendar();
        nowPlusTolerence.setTime(date);
        nowPlusTolerence.add(12, tolerance);
        return this.created != null && this.created.after(nowPlusTolerence.getTime());
    }

    public String toString() {
        return "Timestamp{created=" + this.created + ", expires=" + this.expires + ", id='" + this.id + "'}";
    }
}

