/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.HashMap;
import java.util.Map;
import org.sourceid.util.log.internal.Masker;
import org.sourceid.util.log.internal.Saml1xMasker;
import org.sourceid.util.log.internal.Saml2Masker;
import org.sourceid.wstrust.model.BinarySecurityTokenJwtMasker;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.UsernameTokenPwdMasker;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class TokenMaskerFactory {
    private static Map<String, Masker> tokenType2Masker = new HashMap<String, Masker>();

    public static Masker getTokenMasker(String tokenType) {
        return tokenType2Masker.get(tokenType);
    }

    static {
        tokenType2Masker.put(Saml11SecurityToken.TYPE, new Saml1xMasker());
        tokenType2Masker.put(Saml20SecurityToken.TYPE, new Saml2Masker());
        tokenType2Masker.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken", new UsernameTokenPwdMasker());
        tokenType2Masker.put(WsTrustTokenType.JWT.getUri(), new BinarySecurityTokenJwtMasker());
    }
}

