/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.log.internal.Masker;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.TokenMaskerFactory;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.addressing.WsaVersion;

public class WsTrustOutMessageContext
extends OutMessageContext {
    private SoapHeaders headers;
    private WSTrustVersion wsTrustVersion;
    private WsaVersion wsaVersion;
    private RequestType requestType;
    private String tokenType;
    private RequestSecurityTokenResponse rstr;
    private WsTrustInMessageContext inMessageContext;

    public WsTrustOutMessageContext(Role role) {
        super(role);
    }

    public WsTrustOutMessageContext(WsTrustInMessageContext inCtx) {
        super(inCtx.getRoleType());
        this.setEntityId(inCtx.getEntityId());
        this.setWsTrustVersion(inCtx.getWsTrustVersion());
        this.setWsaVersion(inCtx.getWsaVersion());
        this.inMessageContext = inCtx;
    }

    public SoapHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(SoapHeaders headers) {
        this.headers = headers;
    }

    public WsaVersion getWsaVersion() {
        return this.wsaVersion;
    }

    public void setWsaVersion(WsaVersion wsaVersion) {
        this.wsaVersion = wsaVersion;
    }

    public void setWsTrustVersion(WSTrustVersion wsTrustVersion) {
        this.wsTrustVersion = wsTrustVersion;
    }

    public WSTrustVersion getWsTrustVersion() {
        return this.wsTrustVersion;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRstr(RequestSecurityTokenResponse rstr) {
        this.rstr = rstr;
    }

    public RequestSecurityTokenResponse getRstr() {
        return this.rstr;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public WsTrustInMessageContext getInMessageContext() {
        return this.inMessageContext;
    }

    @Override
    public StringBuilder getStandardInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(" | ").append("Connection ID: ").append(this.getEntityId()).append(" (").append((Object)this.getRoleType()).append(")");
        String msgType = null;
        String id = null;
        if (this.getXmlObject() != null) {
            msgType = this.getHeaders().getAction();
            if (this.getRstr().getRequestedSecurityToken() != null && this.getRstr().getRequestedSecurityToken().getToken() instanceof SamlSecurityToken) {
                id = this.getRstr().getRequestedSecurityToken().getToken().getId();
            }
        }
        if (msgType != null) {
            sb.append(" | ").append(msgType);
        }
        if (id != null) {
            sb.append(" | ").append("SAML ID: ").append(id);
        }
        return sb;
    }

    @Override
    protected XmlObject mask() {
        XmlObject xmlObj = this.getXmlObject();
        Masker masker = TokenMaskerFactory.getTokenMasker(this.getTokenType());
        if (xmlObj != null && masker != null) {
            return masker.mask(xmlObj, this.getMaskedAttributeNames());
        }
        return xmlObj;
    }
}

