/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import com.pingidentity.crypto.Cert;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class X509SecurityToken
extends BinarySecurityToken {
    public static final String TYPE = WsTrustTokenType.X509.getUri();
    private X509Certificate certificate;
    private SignatureStatus signatureStatus = SignatureStatus.UNVERIFIED;

    public X509SecurityToken() {
        super(TYPE);
    }

    @Override
    public void setEncodedData(String encodedData) {
        super.setEncodedData(encodedData);
        byte[] decoded = this.getDecodedData();
        try {
            Cert cert = Cert.importCert(decoded);
            this.setCertificate(cert.getX509Certificate());
        }
        catch (CertificateException e) {
            throw new ProcessRuntimeException("Can't decode the encoded certificate", e);
        }
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    public SignatureStatus getSignatureStatus() {
        return this.signatureStatus;
    }

    public void setSignatureStatus(SignatureStatus signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    @Override
    public Date getExpiryDate() {
        return this.certificate.getNotAfter();
    }

    @Override
    public Date getCreatedDate() {
        return this.certificate.getNotBefore();
    }
}

