/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model.mapper;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.protocol.xmlenc10.xml.EncryptedDataType;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.wstrust.model.EncryptedSaml11SecurityToken;
import org.sourceid.wstrust.model.EncryptedSaml20SecurityToken;
import org.sourceid.wstrust.model.EncryptedSamlSecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.mapper.TokenVisitCallback;

public class SamlSecurityTokenVisitCallback
extends TokenVisitCallback {
    public static final QName SAML11_ASSERTION_NAME = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    public static final QName SAML11_ENCRYPTED_ASSERTION_NAME = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    public static final QName SAML20_ASSERTION_NAME = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
    public static final QName SAML20_ENCRYPTED_ASSERTION_NAME = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
    public static final QName KeyIdentifier = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    public static final QName X509SerialNumber = new QName("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
    public static final QName KeyInfo = new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");

    public SamlSecurityTokenVisitCallback(List<SecurityToken> tokenList) {
        super(tokenList);
    }

    @Override
    public void visit(XmlObject xmlObject, QName name) {
        if (name.equals(SAML11_ASSERTION_NAME)) {
            org.sourceid.protocol.saml11.xml.AssertionType assertion = (org.sourceid.protocol.saml11.xml.AssertionType)xmlObject;
            Saml11SecurityToken token = new Saml11SecurityToken();
            token.setAssertion(assertion);
            this.tokenList.add(token);
        } else if (name.equals(SAML20_ASSERTION_NAME)) {
            AssertionType assertion = (AssertionType)xmlObject;
            Saml20SecurityToken token = new Saml20SecurityToken();
            token.setAssertion(assertion);
            this.tokenList.add(token);
        } else if (name.equals(SAML20_ENCRYPTED_ASSERTION_NAME) || name.equals(SAML11_ENCRYPTED_ASSERTION_NAME)) {
            XmlObject encryptedData = null;
            encryptedData = xmlObject instanceof EncryptedDataType ? xmlObject : XmlBeansUtil.getFirstChild(xmlObject);
            EncryptedSamlSecurityToken token = null;
            if (name.equals(SAML20_ENCRYPTED_ASSERTION_NAME)) {
                token = new EncryptedSaml20SecurityToken();
            } else if (name.equals(SAML11_ENCRYPTED_ASSERTION_NAME)) {
                token = new EncryptedSaml11SecurityToken();
            }
            token.setEncryptedData(encryptedData);
            XmlObject keyInfo = XmlObjectWalker.findChild(KeyInfo, encryptedData);
            XmlObject keyId = XmlObjectWalker.find(KeyIdentifier, keyInfo);
            if (keyId != null) {
                XmlCursor xmlCursor = keyId.newCursor();
                token.setCertificateThumbpint(xmlCursor.getTextValue());
                XmlBeansUtil.disposeCursor(xmlCursor);
            } else {
                XmlObject serialNumber = XmlObjectWalker.find(X509SerialNumber, keyInfo);
                if (serialNumber != null) {
                    XmlCursor xmlCursor = serialNumber.newCursor();
                    token.setCertificateSerial(xmlCursor.getTextValue());
                    XmlBeansUtil.disposeCursor(xmlCursor);
                }
            }
            this.tokenList.add(token);
        } else {
            throw new ProcessRuntimeException("Unknown version of SAML assertion");
        }
    }
}

