/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model.mapper;

import com.pingidentity.common.util.xml.QNameBoundVisitCallback;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.Claim;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.BinarySecret;
import org.sourceid.wstrust.model.Entropy;
import org.sourceid.wstrust.model.KeyType;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SecurityTokenReference;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.mapper.WSTrustXmlMapper;
import org.sourceid.wstrust.model.mapper.XmlLocalName;
import org.sourceid.wstrust.wsse.SecurityTokenReferenceProcessor;

public class WSTrustRstVisitCallback
implements XmlObjectWalker.VisitCallback {
    public static final QName METADATA_ATTRIBUTE = new QName("http://pingidentity.com/sts/metadata-ext.xsd", "attribute");
    private RequestSecurityToken rst = new RequestSecurityToken();
    private SoapHeaders headers = new SoapHeaders();

    @Override
    public void visit(XmlObject xmlObject, QName name) {
        XmlLocalName localName = XmlLocalName.fromLocalName(name.getLocalPart());
        if (localName != null) {
            switch (localName) {
                case ADDRESS: {
                    XmlCursor xCur = xmlObject.newCursor();
                    if (!xCur.toParent() || !XmlLocalName.ENDPOINT_REFERENCE.getLocalName().equals(xCur.getName().getLocalPart()) || !xCur.toParent() || !XmlLocalName.APPLIES_TO.getLocalName().equals(xCur.getName().getLocalPart())) break;
                    XmlBeansUtil.disposeCursor(xCur);
                    xCur = xmlObject.newCursor();
                    this.rst.setAppliesTo(new AppliesTo(xCur.getTextValue().trim()));
                    this.rst.setAddressNamespace(xCur.getName().getNamespaceURI());
                    XmlBeansUtil.disposeCursor(xCur);
                    break;
                }
                case REQUEST_TYPE: {
                    XmlCursor xCur = xmlObject.newCursor();
                    RequestType requestType = RequestType.fromUri(xCur.getTextValue().trim());
                    this.rst.setRequestType(requestType);
                    XmlBeansUtil.disposeCursor(xCur);
                    break;
                }
                case TOKEN_TYPE: {
                    XmlCursor xCur = xmlObject.newCursor();
                    this.rst.setTokenType(xCur.getTextValue().trim());
                    XmlBeansUtil.disposeCursor(xCur);
                    break;
                }
                case METADATA: {
                    this.rst.setMetadata(this.parseMetadata(xmlObject));
                    break;
                }
                case KEY_SIZE: {
                    XmlCursor xCur = xmlObject.newCursor();
                    this.rst.setKeySize(Integer.parseInt(xCur.getTextValue().trim()));
                    XmlBeansUtil.disposeCursor(xCur);
                    break;
                }
                case KEY_TYPE: {
                    XmlCursor xCur = xmlObject.newCursor();
                    this.rst.setKeyType(KeyType.fromUri(xCur.getTextValue()));
                    XmlBeansUtil.disposeCursor(xCur);
                    break;
                }
                case ENTROPY: {
                    this.rst.setEntropy(this.parseEntropy(xmlObject));
                    break;
                }
                case COMPUTED_KEY_ALGORITHM: {
                    XmlCursor xCur = xmlObject.newCursor();
                    this.rst.setComputedKeyAlgorithm(xCur.getTextValue().trim());
                    break;
                }
                case VALIDATE_TARGET: {
                    if (this.rst.getValidateTarget() == null) {
                        this.rst.setValidateTarget(this.lookForToken(xmlObject, XmlLocalName.VALIDATE_TARGET.getLocalName()));
                        break;
                    }
                    throw new WSTrustException("Multiple ValidateTarget elements encountered, aborting processing WS-Trust request.");
                }
                case ON_BEHALF_OF: {
                    if (this.rst.getOnBehalfOf() == null) {
                        if (this.rst.getActAs() == null) {
                            this.rst.setOnBehalfOf(this.lookForToken(xmlObject, XmlLocalName.ON_BEHALF_OF.getLocalName()));
                            break;
                        }
                        throw new WSTrustException("Encountered both OnBehalfOf and ActAs elements, these elements are mutually exclusive.  Aborting processing of WS-Trust request.");
                    }
                    throw new WSTrustException("Multiple OnBehalfOf elements encountered, aborting processing of WS-Trust request.");
                }
                case ACT_AS: {
                    if (this.rst.getActAs() == null) {
                        if (this.rst.getOnBehalfOf() == null) {
                            this.rst.setActAs(this.lookForToken(xmlObject, XmlLocalName.ACT_AS.getLocalName()));
                            break;
                        }
                        throw new WSTrustException("Encountered both ActAs and OnBehalfOf elements, these elements are mutually exclusive.  Aborting processing of WS-Trust request.");
                    }
                    throw new WSTrustException("Multiple ActAs elements encountered, aborting processing of WS-Trust request.");
                }
                case CLAIM: {
                    XmlCursor xCur = xmlObject.newCursor();
                    this.rst.addClaim(new Claim(xCur.getAttributeText(new QName("Uri")), Boolean.parseBoolean(xCur.getAttributeText(new QName("Optional")))));
                    break;
                }
            }
        }
    }

    private Entropy parseEntropy(XmlObject root) {
        XmlObjectWalker walker = new XmlObjectWalker(root);
        final Entropy entropy = new Entropy();
        walker.addCallback(new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xmlObject, QName qName) {
                if (XmlLocalName.BINARY_SECRET.equals((Object)XmlLocalName.fromLocalName(qName.getLocalPart()))) {
                    BinarySecret binarySecret = new BinarySecret();
                    binarySecret.setValue(XmlBeansUtil.getTextValue(xmlObject));
                    entropy.setBinarySecret(binarySecret);
                }
            }
        });
        walker.walkEveryNode();
        return entropy;
    }

    private AttributeMap parseMetadata(XmlObject root) {
        XmlObjectWalker walker = new XmlObjectWalker(root);
        final AttributeMap attributes = new AttributeMap();
        walker.addCallback(new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xObj, QName qName) {
                if (METADATA_ATTRIBUTE.equals(qName)) {
                    attributes.put(XmlBeansUtil.getAttributeValue(xObj, "name"), XmlBeansUtil.getTextValue(xObj));
                }
            }
        });
        walker.walkEveryNode();
        return attributes;
    }

    private SecurityToken lookForToken(XmlObject xmlObject, String elementName) {
        XmlObjectWalker walker2 = new XmlObjectWalker(xmlObject);
        final ArrayList<SecurityToken> tokenList = new ArrayList<SecurityToken>();
        QNameBoundVisitCallback callback = WSTrustXmlMapper.createTokenCallback(tokenList);
        callback.addCallbackBinding(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", XmlLocalName.SECURITY_TOKEN_REFERENCE.getLocalName()), new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xmlObject, QName name) {
                SecurityTokenReferenceProcessor referenceProcessor = new SecurityTokenReferenceProcessor(WSTrustRstVisitCallback.this.headers);
                SecurityTokenReference reference = WSTrustXmlMapper.mapToSecurityTokenReference(xmlObject);
                SecurityToken token = referenceProcessor.resolveReference(reference);
                tokenList.add(token);
            }
        });
        walker2.addCallback(callback);
        walker2.walkChildern();
        int noOfTokens = tokenList.size();
        if (noOfTokens > 1) {
            throw new WSTrustException(elementName + " with more than one token is unsupported.");
        }
        if (noOfTokens == 0) {
            throw new WSTrustException(elementName + " with no security token is unsupported.");
        }
        SecurityToken token = (SecurityToken)tokenList.get(0);
        return token;
    }

    public RequestSecurityToken getRst() {
        return this.rst;
    }

    public void setRst(RequestSecurityToken rst) {
        this.rst = rst;
    }

    public SoapHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(SoapHeaders headers) {
        this.headers = headers;
    }
}

