/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model.mapper;

import com.pingidentity.common.util.xml.QNameBoundVisitCallback;
import com.pingidentity.common.util.xml.RetrieveVisitCallback;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlObjectBuilder;
import com.pingidentity.common.util.xml.XmlObjectWalker;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wss.x2004.x01.oasis200401WssWssecuritySecext10.BinarySecurityTokenType;
import org.sourceid.wstrust.crypto.IdBasedResolver;
import org.sourceid.wstrust.model.BinarySecret;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestedProofToken;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SecurityTokenReference;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.Timestamp;
import org.sourceid.wstrust.model.mapper.BinarySecurityTokenVisitCallback;
import org.sourceid.wstrust.model.mapper.SamlSecurityTokenVisitCallback;
import org.sourceid.wstrust.model.mapper.SignatureVisitCallback;
import org.sourceid.wstrust.model.mapper.UsernameTokenVisitCallback;
import org.sourceid.wstrust.model.mapper.WSTrustRstVisitCallback;
import org.sourceid.wstrust.model.mapper.XmlLocalName;
import org.sourceid.wstrust.model.mapper.XmlMappingException;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.wsse.WsseProcessingException;
import org.sourceid.wstrust.wsse.WsseProcessor;

public class WSTrustXmlMapper {
    public static final QName QN_KEY_IDENTIFIER = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", XmlLocalName.KEY_IDENTIFIER.getLocalName());
    public static final QName QN_REFERENCE = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", XmlLocalName.REFERENCE.getLocalName());
    public static final QName QN_TOKEN_TYPE = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", XmlLocalName.TOKEN_TYPE.getLocalName());

    public static RequestSecurityToken mapToRequestSecurityToken(XmlObject xmlObject, SoapHeaders headers) {
        XmlObjectWalker xmlObjectWalker = new XmlObjectWalker(xmlObject);
        WSTrustRstVisitCallback callback = new WSTrustRstVisitCallback();
        RequestSecurityToken rst = new RequestSecurityToken();
        callback.setRst(rst);
        callback.setHeaders(headers);
        xmlObjectWalker.addCallback(callback);
        xmlObjectWalker.walkEveryNode();
        return rst;
    }

    public static SoapHeaders mapSoapHeaders(XmlObject xHeader, IdBasedResolver resolver) {
        SoapHeaders soapHeaders = new SoapHeaders();
        XmlObjectWalker walker = new XmlObjectWalker(xHeader);
        walker.addCallback(WSTrustXmlMapper.soapHeadersCallback(soapHeaders, resolver));
        walker.walkEveryNode();
        return soapHeaders;
    }

    private static XmlObjectWalker.VisitCallback soapHeadersCallback(final SoapHeaders soapHeaders, final IdBasedResolver resolver) {
        return new XmlObjectWalker.VisitCallback(){

            @Override
            public void visit(XmlObject xObj, QName qName) {
                resolver.register(xObj);
                XmlLocalName localName = XmlLocalName.fromLocalName(qName.getLocalPart());
                if (localName != null) {
                    switch (localName) {
                        case ACTION: {
                            XmlCursor xmlCursor = xObj.newCursor();
                            soapHeaders.setAction(xmlCursor.getTextValue());
                            soapHeaders.setActionNamespaceURI(qName.getNamespaceURI());
                            XmlBeansUtil.disposeCursor(xmlCursor);
                            break;
                        }
                        case MESSAGE_ID: {
                            XmlCursor xmlCursor = xObj.newCursor();
                            soapHeaders.setMessageId(xmlCursor.getTextValue());
                            soapHeaders.setMessageIdNamespaceURI(qName.getNamespaceURI());
                            XmlBeansUtil.disposeCursor(xmlCursor);
                            break;
                        }
                        case SECURITY: {
                            XmlObjectWalker walker2 = new XmlObjectWalker(xObj);
                            walker2.addCallback(new XmlObjectWalker.VisitCallback(){

                                @Override
                                public void visit(XmlObject xmlObject, QName qName) {
                                    XmlLocalName localName = XmlLocalName.fromLocalName(qName.getLocalPart());
                                    if (localName != null) {
                                        switch (localName) {
                                            case TIMESTAMP: {
                                                Timestamp timeStamp = new Timestamp(xmlObject);
                                                soapHeaders.setTimestamp(timeStamp);
                                                break;
                                            }
                                        }
                                    }
                                }
                            });
                            ArrayList<SecurityToken> tokenList = new ArrayList<SecurityToken>();
                            QNameBoundVisitCallback callback = WSTrustXmlMapper.createTokenCallback(tokenList);
                            callback.addCallbackBinding(SignatureVisitCallback.BIND_NAME, new SignatureVisitCallback(soapHeaders));
                            walker2.addCallback(callback);
                            walker2.walkChildern();
                            soapHeaders.addSecurityTokens(tokenList);
                            break;
                        }
                    }
                }
            }
        };
    }

    public static QNameBoundVisitCallback createTokenCallback(List<SecurityToken> tokenList) {
        QNameBoundVisitCallback callback = new QNameBoundVisitCallback();
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML11_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML11_ENCRYPTED_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML20_ENCRYPTED_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(SamlSecurityTokenVisitCallback.SAML20_ASSERTION_NAME, new SamlSecurityTokenVisitCallback(tokenList));
        callback.addCallbackBinding(UsernameTokenVisitCallback.USERNAME_TOKEN_NAME, new UsernameTokenVisitCallback(tokenList));
        callback.addCallbackBinding(BinarySecurityTokenVisitCallback.BINARY_TOKEN_NAME, new BinarySecurityTokenVisitCallback(tokenList));
        return callback;
    }

    public static XmlObject map(RequestSecurityTokenResponse rstr, WSTrustVersion version, String wst, WsseProcessor wsseProcessor) {
        try {
            XmlObject xmlToken;
            if (rstr.hasValidateStatus()) {
                XmlObject rstrXmlObject = XmlObjectBuilder.element(new QName(wst, "RequestSecurityTokenResponse"), XmlObjectBuilder.element(new QName(wst, "TokenType"), rstr.getTokenType()), XmlObjectBuilder.element(new QName(wst, "Status"), XmlObjectBuilder.element(new QName(wst, "Code"), rstr.getValidateStatus())));
                if (version.useResponseCollection()) {
                    rstrXmlObject = XmlObjectBuilder.element(new QName(wst, "RequestSecurityTokenResponseCollection"), rstrXmlObject);
                }
                return rstrXmlObject;
            }
            SecurityToken token = rstr.getRequestedSecurityToken().getToken();
            if (token instanceof SamlSecurityToken) {
                xmlToken = ((SamlSecurityToken)token).getAssertion();
            } else if (token instanceof BinarySecurityToken) {
                xmlToken = WSTrustXmlMapper.serialize((BinarySecurityToken)token);
            } else {
                throw new XmlMappingException("Unsupported security token " + token.getType());
            }
            Timestamp lifetime = null;
            if (token.getCreatedDate() != null || token.getExpiryDate() != null) {
                lifetime = wsseProcessor.generateTimestamp(token.getCreatedDate(), token.getExpiryDate());
            }
            String rstrTokenType = rstr.getTokenType();
            if (token instanceof Saml11O365SecurityToken) {
                rstrTokenType = "urn:oasis:names:tc:SAML:1.0:assertion";
            }
            XmlObject rstrXmlObject = XmlObjectBuilder.element(new QName(wst, "RequestSecurityTokenResponse"), XmlObjectBuilder.element(new QName(wst, "TokenType"), rstrTokenType), XmlObjectBuilder.element(new QName(wst, "RequestedSecurityToken"), WSTrustXmlMapper.asDocument(xmlToken)), WSTrustXmlMapper.buildLifetime(wst, lifetime), WSTrustXmlMapper.buildRequestedAttachedReference(wst, version, rstr), WSTrustXmlMapper.buildProofToken(wst, version, rstr), WSTrustXmlMapper.buildEntropy(wst, version, rstr), WSTrustXmlMapper.buildAppliesTo(wst, version, rstr));
            if (version.useResponseCollection()) {
                rstrXmlObject = XmlObjectBuilder.element(new QName(wst, "RequestSecurityTokenResponseCollection"), rstrXmlObject);
            }
            return rstrXmlObject;
        }
        catch (XmlException e) {
            throw new XmlMappingException(e);
        }
    }

    private static XmlObject buildAppliesTo(String wst, WSTrustVersion version, RequestSecurityTokenResponse rstr) {
        String wsa;
        String wsp = version.getCorrespondingWSPNamespace().getUri();
        String string = wsa = rstr.getAddressNamespace() == null ? version.getCorrespondingWSANamespace().getUri() : rstr.getAddressNamespace();
        if (rstr.getAppliesTo() != null) {
            return XmlObjectBuilder.element(new QName(wsp, "AppliesTo"), XmlObjectBuilder.element(new QName(wsa, "EndpointReference"), XmlObjectBuilder.element(new QName(wsa, "Address"), rstr.getAppliesTo().getAppliesToURI().toString())));
        }
        return null;
    }

    private static XmlObject buildRequestedAttachedReference(String wst, WSTrustVersion version, RequestSecurityTokenResponse rstr) {
        String wsse = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        String wsse1 = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
        if (rstr.getRequestedSecurityToken().getToken() instanceof SamlSecurityToken) {
            SamlSecurityToken samlSecurityToken = (SamlSecurityToken)rstr.getRequestedSecurityToken().getToken();
            String tokenType = samlSecurityToken.getType();
            if (samlSecurityToken instanceof Saml11O365SecurityToken) {
                tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            }
            return XmlObjectBuilder.element(new QName(wst, "RequestedAttachedReference"), XmlObjectBuilder.element(new QName(wsse, "SecurityTokenReference"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr(new QName(wsse1, "TokenType"), tokenType)), XmlObjectBuilder.element(new QName(wsse, "KeyIdentifier"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr("ValueType", samlSecurityToken.getIdentifierTypeUri())), samlSecurityToken.getId())));
        }
        return null;
    }

    private static XmlObject asDocument(XmlObject xmlToken) throws XmlException {
        return XmlBeansUtil.isDocument(xmlToken) ? xmlToken : XmlBeansUtil.wrapTypeInDocument(xmlToken);
    }

    private static BinarySecurityTokenType serialize(BinarySecurityToken binaryToken) {
        BinarySecurityTokenType binaryXmlToken = BinarySecurityTokenType.Factory.newInstance();
        if (binaryToken.getEncodingType() != null) {
            binaryXmlToken.setEncodingType(binaryToken.getEncodingType());
        }
        if (binaryToken.getId() != null) {
            binaryXmlToken.setId(binaryToken.getId());
        }
        if (binaryToken.getType() != null) {
            binaryXmlToken.setValueType(binaryToken.getType());
        }
        if (binaryToken.getEncodedData() == null) {
            throw new XmlMappingException("Binary token contains no data");
        }
        binaryXmlToken.setStringValue(binaryToken.getEncodedData());
        return binaryXmlToken;
    }

    private static XmlObject buildProofToken(String wst, WSTrustVersion version, RequestSecurityTokenResponse rstr) {
        String wsu = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        RequestedProofToken proofToken = rstr.getRequestedProofToken();
        if (proofToken != null && proofToken.isBinarySecretDefined()) {
            BinarySecret secret = rstr.getRequestedProofToken().getBinarySecret();
            return XmlObjectBuilder.element(new QName(wst, "RequestedProofToken"), XmlObjectBuilder.element(new QName(wst, "BinarySecret"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr(new QName(wsu, "Id"), secret.getId()), XmlObjectBuilder.attr("Type", secret.getKeyType().toUri(version))), secret.getValue()));
        }
        if (proofToken != null && proofToken.isComputedKeyDefined()) {
            return XmlObjectBuilder.element(new QName(wst, "RequestedProofToken"), XmlObjectBuilder.element(new QName(wst, "ComputedKey"), proofToken.getComputedKey().getAlgorithmUri()));
        }
        return null;
    }

    private static XmlObject buildEntropy(String wst, WSTrustVersion version, RequestSecurityTokenResponse rstr) {
        String wsu = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        RequestedProofToken proofToken = rstr.getRequestedProofToken();
        if (proofToken != null && proofToken.isComputedKeyDefined()) {
            BinarySecret secret = rstr.getRequestedProofToken().getComputedKey();
            return XmlObjectBuilder.element(new QName(wst, "Entropy"), XmlObjectBuilder.element(new QName(wst, "BinarySecret"), XmlObjectBuilder.attrs(XmlObjectBuilder.attr("Type", secret.getKeyType().toUri(version))), secret.getValue()));
        }
        return null;
    }

    private static XmlObject buildLifetime(String wst, Timestamp lifetime) {
        XmlObject xLifetime = lifetime != null ? XmlObjectBuilder.element(new QName(wst, "Lifetime"), new XmlObject[]{lifetime.buildCreatedDocument(), lifetime.buildExpiresDocument()}) : null;
        return xLifetime;
    }

    public static SecurityTokenReference mapToSecurityTokenReference(XmlObject str) {
        XmlObjectWalker xmlObjectWalker = new XmlObjectWalker(str);
        RetrieveVisitCallback callback = new RetrieveVisitCallback(QN_REFERENCE, QN_KEY_IDENTIFIER);
        xmlObjectWalker.addCallback(callback);
        xmlObjectWalker.walkEveryNode();
        SecurityTokenReference result = new SecurityTokenReference();
        result.setTokenType(XmlBeansUtil.getAttributeValue(str, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"));
        XmlObject ref = callback.getXmlObject(QN_REFERENCE);
        if (ref != null) {
            result.setIdentifier(XmlBeansUtil.getAttributeValue(ref, "URI"));
            result.setValueType(XmlBeansUtil.getAttributeValue(ref, "ValueType"));
            return result;
        }
        XmlObject keyIdentifier = callback.getXmlObject(QN_KEY_IDENTIFIER);
        if (keyIdentifier != null) {
            result.setValueType(XmlBeansUtil.getAttributeValue(keyIdentifier, "ValueType"));
            result.setIdentifier(XmlBeansUtil.getTextValue(keyIdentifier));
            return result;
        }
        throw new WsseProcessingException("SecurityTokenReference doesn't contain wsse:Reference or wsse:KeyIdentifier element. Only these types supported.");
    }
}

