/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.processor.saml;

import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.X509CertPathValidatorSupport;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.wstrust.mgmt.X509DistinguishedNameFilter;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;
import org.sourceid.wstrust.validator.DistinguishedNameRowValidator;
import sun.security.x509.X500Name;

public abstract class AbstractSamlProcessor {
    protected RevocationChecker revocationChecker = GlobalRegistry.getService(RevocationChecker.class);
    private TrustedCAsManager trustedCAsManager = GlobalRegistry.getService(TrustedCAsManager.class);
    protected static final RequiredFieldValidator REQUIRED_VALIDATOR = new RequiredFieldValidator();
    protected TokenProcessorDescriptor descriptor;
    protected static final String ISSUER_TABLE_NAME = "Valid Certificate Issuer DNs";
    protected static final String FIELD_ISSUER_DN = "Issuer DN";
    protected static final String SUBJECT_TABLE_NAME = "Valid Certificate Subject DNs";
    protected static final String FIELD_SUBJECT_DN = "Subject DN";
    protected static final String FIELD_AUDIENCE = "Audience";
    protected List<String> issuerDNs = new LinkedList<String>();
    protected List<String> subjectDNs = new LinkedList<String>();
    protected String audience;
    protected String name;
    protected GuiConfigDescriptor gui;
    protected Set<String> contract;
    protected X509DistinguishedNameFilter subjectDnFilter = new X509DistinguishedNameFilter();
    protected X509DistinguishedNameFilter issuerDnFilter = new X509DistinguishedNameFilter();
    protected static final String DESCRIPTION_FORMAT = "%s Token Processor";

    public AbstractSamlProcessor() {
        this.name = String.format(DESCRIPTION_FORMAT, this.getSimpleName());
        this.gui = new GuiConfigDescriptor(this.name);
        this.contract = Collections.singleton(AssertionMapKeys.getNameIdValueKey());
        TextFieldDescriptor audience = new TextFieldDescriptor(FIELD_AUDIENCE, "Provide the Uniform Resource Identifier (URI) that uniquely identifies your federation gateway for this SAML protocol.  The incoming SAML <audience> value must match this URI. ");
        audience.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        this.gui.addField((FieldDescriptor)audience);
        String issuerTableDesc = "If Issuer DNs are specified here (optional), then only those issuers are considered valid for verifying incoming digital signatures. Otherwise, all trusted Certificate Authorities (CAs) are used to verify signatures.";
        TableDescriptor caTable = new TableDescriptor(ISSUER_TABLE_NAME, issuerTableDesc);
        String issuerDesc = "List of Acceptable Root CA Issuers";
        TextFieldDescriptor caAlias = new TextFieldDescriptor(FIELD_ISSUER_DN, issuerDesc);
        caAlias.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        caTable.addValidator((RowValidator)new DistinguishedNameRowValidator());
        caTable.addRowField((FieldDescriptor)caAlias);
        String subjectTableDesc = "If Subject DNs are specified here (optional), then only matching certificates are considered valid for verifying incoming digital signatures. Otherwise, all trusted CAs--or those listed above--are used to verify signatures.";
        TableDescriptor subjectTable = new TableDescriptor(SUBJECT_TABLE_NAME, subjectTableDesc);
        String subjectDesc = "List of Acceptable Certificates";
        TextFieldDescriptor subjectField = new TextFieldDescriptor(FIELD_SUBJECT_DN, subjectDesc);
        subjectField.addValidator((FieldValidator)REQUIRED_VALIDATOR);
        subjectTable.addValidator((RowValidator)new DistinguishedNameRowValidator());
        subjectTable.addRowField((FieldDescriptor)subjectField);
        this.gui.addTable(caTable);
        this.gui.addTable(subjectTable);
        this.gui.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                this.checkForDuplicates(configuration.getTable(AbstractSamlProcessor.ISSUER_TABLE_NAME));
                this.checkForDuplicates(configuration.getTable(AbstractSamlProcessor.SUBJECT_TABLE_NAME));
            }

            private void checkForDuplicates(Table table) throws ValidationException {
                HashSet<X500Name> distinguishedNames = new HashSet<X500Name>();
                for (Row row : table.getRows()) {
                    String distinguishedName = row.getFieldValue(((Field)row.getFields().get(0)).getName());
                    try {
                        distinguishedNames.add(new X500Name(distinguishedName));
                    }
                    catch (IOException e) {
                        throw new ValidationException("Error parsing distinguished name: " + distinguishedName);
                    }
                }
                if (table.getRows().size() > distinguishedNames.size()) {
                    throw new ValidationException(String.format("Table '%s' contains duplicate distinguished name values", table.getName()));
                }
            }
        });
    }

    public void configure(Configuration configuration) {
        Table subjects;
        Table table = configuration.getTable(ISSUER_TABLE_NAME);
        if (table != null) {
            for (Row row : table.getRows()) {
                String alias = row.getFieldValue(FIELD_ISSUER_DN);
                this.issuerDNs.add(alias);
            }
            this.issuerDnFilter.setDistinguishedNames(this.issuerDNs);
        }
        if ((subjects = configuration.getTable(SUBJECT_TABLE_NAME)) != null) {
            for (Row row : subjects.getRows()) {
                this.subjectDNs.add(row.getFieldValue(FIELD_SUBJECT_DN));
            }
            this.subjectDnFilter.setDistinguishedNames(this.subjectDNs);
        }
        this.audience = configuration.getFieldValue(FIELD_AUDIENCE);
    }

    protected void ensureNotRevoked(X509Certificate[] chain) throws InvalidTokenException {
        try {
            this.revocationChecker.check(chain);
        }
        catch (RevokedCertException e) {
            throw new InvalidTokenException("Certificate revoked: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void ensureTrustedCert(X509Certificate[] chain) throws InvalidTokenException {
        X509CertPathValidatorSupport pathValidator = new X509CertPathValidatorSupport(chain, true);
        pathValidator.addTrustAnchors(this.getTrustedCAsManager().getAllTrustAnchors());
        try {
            pathValidator.validate();
        }
        catch (CertPathValidatorException e) {
            throw new InvalidTokenException("Certificate path validation failed: ", (Throwable)e);
        }
        X509Certificate rootCert = chain[chain.length - 1];
        if (!this.issuerDnFilter.isDistinguishedNameAcceptable(rootCert.getIssuerX500Principal())) {
            throw new InvalidTokenException("SAML assertion issued by an untrusted certificate authority.");
        }
    }

    private TrustedCAsManager getTrustedCAsManager() {
        return this.trustedCAsManager;
    }

    public void setTrustedCAsManager(TrustedCAsManager trustedCAsManager) {
        this.trustedCAsManager = trustedCAsManager;
    }

    protected X509Certificate[] ensureSignatureValid(XmlObject saml) throws InvalidTokenException {
        XmlSignatureVerifier verifier = new XmlSignatureVerifier(saml);
        SignatureResult signatureResult = verifier.getSignatureResult();
        if (SignatureStatus.VALID != signatureResult.getStatus()) {
            throw new InvalidTokenException(signatureResult + " signature on " + this.getSimpleName() + " token.");
        }
        return new X509Certificate[]{verifier.getEmbeddedX509Cert()};
    }

    abstract String getSimpleName();

    protected String getVersion() {
        return "UNDEFINED";
    }

    public void setRevocationChecker(RevocationChecker revocationChecker) {
        this.revocationChecker = revocationChecker;
    }

    public TokenProcessorDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    void setSubjectDnFilter(X509DistinguishedNameFilter subjectDnFilter) {
        this.subjectDnFilter = subjectDnFilter;
    }

    void setIssuerFilter(X509DistinguishedNameFilter issuerDnFilter) {
        this.issuerDnFilter = issuerDnFilter;
    }

    protected void ensureTrustedSigner(X509Certificate[] certChain) throws InvalidTokenException {
        if (!this.subjectDnFilter.isDistinguishedNameAcceptable(certChain[0].getSubjectX500Principal())) {
            throw new InvalidTokenException("SAML assertion signed with untrusted X509 subject.");
        }
    }
}

