/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.processor.saml;

import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginFipsStatus;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;
import org.sourceid.wstrust.processor.saml.AbstractSamlProcessor;
import org.sourceid.wstrust.validator.ValidateSaml11Assertion;

public class Saml11TokenProcessor
extends AbstractSamlProcessor
implements TokenProcessor<Saml11SecurityToken> {
    private ValidateSaml11Assertion conditionsValidator = new ValidateSaml11Assertion();
    private final AssertionAssembler assembler = new AssertionAssembler();

    public Saml11TokenProcessor() {
        this.descriptor = new TokenProcessorDescriptor(this.name, (Plugin)this, this.gui, Saml11SecurityToken.TYPE, this.contract);
        this.descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public TokenContext processToken(Saml11SecurityToken saml) throws InvalidTokenException, TokenProcessingException {
        AssertionType samlXml = saml.getAssertion();
        X509Certificate[] certChain = this.ensureSignatureValid((XmlObject)samlXml);
        this.ensureTrustedSigner(certChain);
        this.ensureTrustedCert(certChain);
        this.ensureNotRevoked(certChain);
        this.ensureConditionsMet(saml);
        return this.copyAttributesToContext(saml);
    }

    private TokenContext copyAttributesToContext(Saml11SecurityToken saml) {
        TokenContext context = new TokenContext();
        AttributeMap attrs = this.assembler.disassemble(saml.getAssertion(), Collections.emptySet());
        context.setSubjectAttributes((Map)attrs);
        return context;
    }

    private void ensureConditionsMet(Saml11SecurityToken saml) throws InvalidTokenException {
        this.conditionsValidator.validate(saml, Collections.singletonList(this.audience));
    }

    public void setValidator(ValidateSaml11Assertion validator) {
        this.conditionsValidator = validator;
    }

    @Override
    String getSimpleName() {
        return "SAML 1.1";
    }

    @Override
    protected String getVersion() {
        return "1.0";
    }
}

