/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.processor.saml;

import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginFipsStatus;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.plugin.process.TokenContext;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.plugin.process.TokenProcessorDescriptor;
import org.sourceid.wstrust.processor.saml.AbstractSamlProcessor;
import org.sourceid.wstrust.validator.ValidateSaml20Assertion;

public class Saml20TokenProcessor
extends AbstractSamlProcessor
implements TokenProcessor<Saml20SecurityToken> {
    private ValidateSaml20Assertion conditionsValidator = new ValidateSaml20Assertion();
    private final AssertionAssembler assembler = new AssertionAssembler();

    public Saml20TokenProcessor() {
        this.descriptor = new TokenProcessorDescriptor(this.name, (Plugin)this, this.gui, Saml20SecurityToken.TYPE, this.contract);
        this.descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public TokenContext processToken(Saml20SecurityToken saml) throws InvalidTokenException, TokenProcessingException {
        AssertionType samlXml = saml.getAssertion();
        X509Certificate[] certChain = this.ensureSignatureValid((XmlObject)samlXml);
        this.ensureTrustedSigner(certChain);
        this.ensureTrustedCert(certChain);
        this.ensureNotRevoked(certChain);
        this.ensureConditionsMet(saml);
        return this.copyAttributesToContext(saml);
    }

    private TokenContext copyAttributesToContext(Saml20SecurityToken saml) {
        TokenContext context = new TokenContext();
        AttributeMap attrs = this.assembler.disassemble(saml.getAssertion());
        context.setSubjectAttributes((Map)attrs);
        return context;
    }

    private void ensureConditionsMet(Saml20SecurityToken saml) throws InvalidTokenException {
        this.conditionsValidator.validate(saml, Collections.singletonList(this.audience));
    }

    @Override
    public TokenProcessorDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public void setValidator(ValidateSaml20Assertion validator) {
        this.conditionsValidator = validator;
    }

    @Override
    String getSimpleName() {
        return "SAML 2.0";
    }

    @Override
    protected String getVersion() {
        return "1.0";
    }
}

