/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.protocol;

import javax.xml.namespace.QName;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestedSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.mapper.WSTrustXmlMapper;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.wsse.WsseProcessingException;

public abstract class WSTrustProtocolManager {
    public RequestSecurityToken receive(WsTrustInMessageContext ctx) {
        RequestSecurityToken rst;
        WSTrustVersion version = this.getWSTrustVersion();
        try {
            rst = WSTrustXmlMapper.mapToRequestSecurityToken(ctx.getRstXmlObject(), ctx.getSoapHeaders());
        }
        catch (WsseProcessingException e) {
            e.setFaultCode(new QName(version.getDocumentNamespace().getUri(), "BadRequest"));
            e.setFaultReason("The specified RequestSecurityToken is not understood.");
            throw e;
        }
        rst.setVersion(version);
        return rst;
    }

    public abstract WSTrustVersion getWSTrustVersion();

    public RequestSecurityTokenResponse transmit(SecurityToken token) {
        return new RequestSecurityTokenResponse(new RequestedSecurityToken(token));
    }

    public RequestSecurityTokenResponse transmit(boolean valid) {
        WSTrustVersion version = this.getWSTrustVersion();
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        rstr.setTokenType(version.getStatus().getUri());
        if (valid) {
            rstr.setValidateStatus(version.getStatusValid().getUri());
        } else {
            rstr.setValidateStatus(version.getStatusInvalid().getUri());
        }
        return rstr;
    }
}

