/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.validator;

import java.util.List;
import org.sourceid.saml20.protocol.ValidateAssertionConditions;
import org.sourceid.saml20.protocol.ValidateAssertionHasSubjectStatements;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.plugin.process.InvalidTokenException;
import org.sourceid.wstrust.validator.ValidateSamlAssertion;

public class ValidateSaml20Assertion
extends ValidateSamlAssertion {
    private final ValidateAssertionConditions validateAssertionConditions;
    private final ValidateAssertionHasSubjectStatements validateAssertionHasSubjectStmts = new ValidateAssertionHasSubjectStatements();

    public ValidateSaml20Assertion() {
        this.validateAssertionHasSubjectStmts.setRequireStatements(false);
        this.validateAssertionConditions = new ValidateAssertionConditions();
        this.initConditionsValidator(this.validateAssertionConditions);
    }

    public void validate(Saml20SecurityToken token, List<String> virtualIds) throws InvalidTokenException {
        AssertionType assertionType = token.getAssertion();
        Assertion assertion = new Assertion(assertionType);
        this.validateAssertionConditions.validate(assertion, virtualIds);
        this.validateAssertionHasSubjectStmts.validate(assertion);
        if (!assertionType.isSetSubject()) {
            assertion.addInvalidRemark("Assertion does not contain a Subject element.");
        }
        this.ensureValid(assertion);
    }
}

