/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector;

import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.FixedSizeAppender;
import com.unboundid.common.util.ProcessStreamReader;
import com.unboundid.common.util.SystemUtils;
import com.unboundid.messages.Message;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;

public abstract class DataCollector {
    protected CollectSupportData collectSupportData;
    private final String name;
    private final CollectSupportData.ZipParentPath zipParent;
    private final Integer pid;
    protected final Message failMessage;
    protected volatile long startTime = -1L;
    protected volatile long stopTime = -1L;
    protected ByteArrayOutputStream commandOutput = new ByteArrayOutputStream();
    protected Boolean filterOutput = false;
    private DataCollectorFileType outputFileType;

    protected DataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent) {
        this(collectSupportData, name, zipParent, null, null);
    }

    protected DataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, DataCollectorFileType fileType) {
        this(collectSupportData, name, zipParent, null, null, fileType);
    }

    public DataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Integer pid, Message failMessage) {
        this(collectSupportData, name, zipParent, pid, failMessage, DataCollectorFileType.DEFAULT);
    }

    protected DataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Integer pid, Message failMessage, DataCollectorFileType fileType) {
        this.collectSupportData = collectSupportData;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.zipParent = zipParent;
        this.pid = pid;
        this.failMessage = failMessage;
        this.outputFileType = fileType;
    }

    public final void writeOutputTo(OutputStream out) throws Exception {
        long timeoutAtMS = System.currentTimeMillis() + this.collectSupportData.getMaximumCommandDurationMS();
        while (!this.isFinished() && timeoutAtMS > System.currentTimeMillis()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                out.write(CollectSupportData.getBytes("Interrupted"));
                break;
            }
        }
        this.commandOutput.writeTo(out);
        if (!this.isFinished()) {
            String message = CollectSupportData.EOL + CollectSupportData.EOL + "WARNING!!!  Command timed-out.";
            this.collectSupportData.log(message);
            out.write(CollectSupportData.getBytes(message));
        }
    }

    public Message getMessage() {
        return null;
    }

    public String getCommand() {
        return null;
    }

    public abstract void start();

    public String getName() {
        return this.name;
    }

    public Date getStartTime() {
        return this.startTime != -1L ? new Date(this.startTime) : null;
    }

    public Date getStopTime() {
        return this.stopTime != -1L ? new Date(this.stopTime) : null;
    }

    public boolean isStarted() {
        return this.startTime != -1L;
    }

    public boolean isFinished() {
        return this.stopTime != -1L;
    }

    public String toString() {
        return this.getName();
    }

    public String getZipParentPath() {
        return this.zipParent != null ? this.zipParent.toString(this.pid) : null;
    }

    protected int createAndStartProcess(ProcessBuilder builder, boolean throwOnBadExitCode, int outputLimit) throws Exception, InterruptedException {
        int exitValue = -1;
        builder.redirectErrorStream(true);
        Process process = builder.start();
        FixedSizeAppender stdout = new FixedSizeAppender(outputLimit);
        ProcessStreamReader stdoutReader = new ProcessStreamReader(process.getInputStream(), (Appendable)stdout, "Process Output Reader for " + this.getName());
        try {
            exitValue = SystemUtils.waitFor((Process)process);
            if (exitValue != 0) {
                this.collectSupportData.log("WARNING: process for collector " + this.getName() + " returned error code " + exitValue);
            }
        }
        catch (InterruptedException ie) {
            this.collectSupportData.log("Interrupted process " + this.getName(), ie);
        }
        try {
            stdoutReader.readFullyAndClose();
            process.getInputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (throwOnBadExitCode && exitValue != 0) {
            throw new RuntimeException(String.format("Exit code is %d", exitValue));
        }
        if (stdoutReader.getException() != null) {
            this.collectSupportData.log("Error reading process output for " + this.getName(), stdoutReader.getException());
        }
        CollectSupportData.write(this.commandOutput, stdout.toString());
        return exitValue;
    }

    public boolean doFilterOutput() {
        return this.filterOutput;
    }

    public boolean doWriteDataCollectorComments() {
        return this.outputFileType != DataCollectorFileType.XML && this.outputFileType != DataCollectorFileType.JSON;
    }

    public DataCollectorFileType getOutputFileType() {
        return this.outputFileType;
    }

    protected void log(String message) {
        this.collectSupportData.log("[" + this.getName() + "]: " + message);
    }

    protected void log(String message, Throwable t) {
        this.collectSupportData.log("[" + this.getName() + "]: " + message, t);
    }
}

