/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector;

import com.pingidentity.csd.server.datacollector.DataCollector;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.GCContextDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.LDAPCommandDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.LDAPSearchDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.MessageDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.ProcessDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.filter.ErrFileFilter;
import com.pingidentity.csd.server.datacollector.process.ProcessDataCollector;
import com.pingidentity.csd.server.datacollector.task.BaselineDataCollector;
import com.pingidentity.csd.server.datacollector.task.ConfigDiffBaselineDataCollector;
import com.pingidentity.csd.server.datacollector.task.ConfigDiffPostSetupDataCollector;
import com.pingidentity.csd.server.datacollector.task.DumpReplicationStateTaskWrapper;
import com.pingidentity.csd.server.datacollector.task.ExternalCollectorTask;
import com.pingidentity.csd.server.datacollector.task.ExternalCollectorTaskWrapper;
import com.pingidentity.csd.server.datacollector.task.FileDataCollector;
import com.pingidentity.csd.server.datacollector.task.FileListProcess;
import com.pingidentity.csd.server.datacollector.task.GCContextCollector;
import com.pingidentity.csd.server.datacollector.task.JarManifestCollector;
import com.pingidentity.csd.server.datacollector.task.LDAPCommandDataCollector;
import com.pingidentity.csd.server.datacollector.task.LdapSearchDataCollector;
import com.pingidentity.csd.server.datacollector.task.VisualizeReplicationStateDataCollector;
import com.pingidentity.csd.server.datacollector.task.pa.PAClusterDataCollector;
import com.pingidentity.csd.server.datacollector.task.pa.PAHeartbeatDataCollector;
import com.pingidentity.csd.server.datacollector.task.pa.PARuntimeConfigDataCollector;
import com.pingidentity.csd.server.datacollector.task.pa.PASslDataCollector;
import com.pingidentity.csd.server.datacollector.task.pa.PAVersionCollector;
import com.pingidentity.csd.server.datacollector.task.pf.PFCertificateDataCollector;
import com.pingidentity.csd.server.datacollector.task.pf.PFClusterDataCollector;
import com.pingidentity.csd.server.datacollector.task.pf.PFHeartbeatDataCollector;
import com.pingidentity.csd.server.datacollector.task.pf.PFSslDataCollector;
import com.pingidentity.csd.server.datacollector.task.pf.PFVersionCollector;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.Command;
import com.pingidentity.csd.server.tools.ProcessBuilderUtil;
import com.pingidentity.csd.server.types.DataCollectorType;
import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.util.AdminSessionUtils;
import com.pingidentity.csd.server.util.MetricsEngineUtils;
import com.pingidentity.csd.tools.collectsupportdata.LDIFUtils;
import com.pingidentity.csd.tools.collectsupportdata.SecurityLevel;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class DataCollectorFactory {
    private final OperatingSystem os = OperatingSystem.forName(System.getProperty("os.name"));
    private CollectSupportData collectSupportData;

    public DataCollectorFactory(CollectSupportData collectSupportData) {
        this.collectSupportData = collectSupportData;
    }

    public List<DataCollector> getDataCollectors(DataCollectorConfiguration dataCollectorConfiguration) {
        ArrayList<DataCollector> dataCollectors = new ArrayList<DataCollector>();
        DataCollectorType collectorType = null;
        try {
            try {
                collectorType = Enum.valueOf(DataCollectorType.class, dataCollectorConfiguration.getType());
            }
            catch (NullPointerException e) {
                System.out.println(e);
            }
            switch (collectorType) {
                case PROCESS: {
                    ProcessDataCollectorConfiguration processDataCollectorConfiguration = new ProcessDataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.addAll(this.getProcessDataCollectorsFromConfig(processDataCollectorConfiguration));
                    break;
                }
                case CONFIG_DIFF_POST_SETUP: {
                    MessageDataCollectorConfiguration configDiffPostSetupDataCollectorConfiguration = new MessageDataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new ConfigDiffPostSetupDataCollector(this.collectSupportData, configDiffPostSetupDataCollectorConfiguration));
                    break;
                }
                case CONFIG_DIFF_BASELINE: {
                    MessageDataCollectorConfiguration configDiffBaselineDataCollectorConfiguration = new MessageDataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new ConfigDiffBaselineDataCollector(this.collectSupportData, configDiffBaselineDataCollectorConfiguration));
                    break;
                }
                case DUMP_REPLICATION_STATE: {
                    MessageDataCollectorConfiguration dumpReplicationStateDataCollectorConfiguration = new MessageDataCollectorConfiguration(dataCollectorConfiguration);
                    if (this.collectSupportData.ldapEnabled() && this.collectSupportData.collectReplicationStateDump) {
                        dataCollectors.add(new DumpReplicationStateTaskWrapper(this.collectSupportData, dumpReplicationStateDataCollectorConfiguration));
                    }
                    break;
                }
                case FILE_LIST: {
                    MessageDataCollectorConfiguration fileListDataCollectorConfiguration = new MessageDataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new FileListProcess(this.collectSupportData, fileListDataCollectorConfiguration));
                    break;
                }
                case ERR_FILE_LIST: {
                    MessageDataCollectorConfiguration errFileListDataCollectorConfiguration = new MessageDataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new FileListProcess(this.collectSupportData, errFileListDataCollectorConfiguration, new ErrFileFilter()));
                    break;
                }
                case GC_CONTEXT: {
                    GCContextDataCollectorConfiguration gcContext = new GCContextDataCollectorConfiguration(dataCollectorConfiguration);
                    if (gcContext.isValidConfiguration()) {
                        dataCollectors.add(new GCContextCollector(this.collectSupportData, gcContext));
                        break;
                    }
                    this.collectSupportData.log(gcContext.getId() + " does not have a valid configuration.Please ensure that the required configuration is present: " + gcContext.getRequiredKeys());
                    break;
                }
                case JAR_MANIFEST: {
                    MessageDataCollectorConfiguration jarManifestDataCollectorConfiguration = new MessageDataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new JarManifestCollector(this.collectSupportData, jarManifestDataCollectorConfiguration));
                    break;
                }
                case LDAP_COMMAND: {
                    LDAPCommandDataCollectorConfiguration ldapCommandDataCollectorConfiguration = new LDAPCommandDataCollectorConfiguration(dataCollectorConfiguration);
                    if (this.collectSupportData.ldapEnabled()) {
                        if (ldapCommandDataCollectorConfiguration.isValidConfiguration()) {
                            dataCollectors.add(new LDAPCommandDataCollector(this.collectSupportData, ldapCommandDataCollectorConfiguration, OperatingSystem.isUNIXBased(this.os)));
                            break;
                        }
                        this.collectSupportData.log(ldapCommandDataCollectorConfiguration.getId() + " does not have a valid configuration.Please ensure that the required configuration is present: " + ldapCommandDataCollectorConfiguration.getRequiredKeys());
                    }
                    break;
                }
                case LDAP_SEARCH: {
                    LDAPSearchDataCollectorConfiguration ldapSearchDataCollectorConfiguration = new LDAPSearchDataCollectorConfiguration(dataCollectorConfiguration);
                    if (this.collectSupportData.ldapEnabled()) {
                        if (ldapSearchDataCollectorConfiguration.isValidConfiguration()) {
                            dataCollectors.add(new LdapSearchDataCollector(this.collectSupportData, ldapSearchDataCollectorConfiguration));
                            break;
                        }
                        this.collectSupportData.log(ldapSearchDataCollectorConfiguration.getId() + " does not have a valid configuration.Please ensure that the required configuration is present: " + ldapSearchDataCollectorConfiguration.getRequiredKeys());
                    }
                    break;
                }
                case BASELINE: {
                    DataCollectorConfiguration pfBaseDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new BaselineDataCollector(this.collectSupportData, pfBaseDataCollectorConfiguration));
                    break;
                }
                case PF_CERTIFICATE: {
                    DataCollectorConfiguration pfCertificateDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PFCertificateDataCollector(this.collectSupportData, pfCertificateDataCollectorConfiguration));
                    break;
                }
                case PF_CLUSTER: {
                    DataCollectorConfiguration pfClusterDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PFClusterDataCollector(this.collectSupportData, pfClusterDataCollectorConfiguration));
                    break;
                }
                case FILE_DATA: {
                    DataCollectorConfiguration pfFileDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new FileDataCollector(this.collectSupportData, pfFileDataCollectorConfiguration));
                    break;
                }
                case PF_HEARTBEAT: {
                    DataCollectorConfiguration pfHearbeatDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PFHeartbeatDataCollector(this.collectSupportData, pfHearbeatDataCollectorConfiguration));
                    break;
                }
                case PF_SSL: {
                    DataCollectorConfiguration pfSslDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PFSslDataCollector(this.collectSupportData, pfSslDataCollectorConfiguration));
                    break;
                }
                case PF_VERSION: {
                    DataCollectorConfiguration pfVersionDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PFVersionCollector(this.collectSupportData, pfVersionDataCollectorConfiguration));
                    break;
                }
                case PA_CLUSTER: {
                    DataCollectorConfiguration paClusterDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PAClusterDataCollector(this.collectSupportData, paClusterDataCollectorConfiguration));
                    break;
                }
                case PA_HEARTBEAT: {
                    DataCollectorConfiguration paHearbeatDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PAHeartbeatDataCollector(this.collectSupportData, paHearbeatDataCollectorConfiguration));
                    break;
                }
                case PA_VERSION: {
                    DataCollectorConfiguration paVersionDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PAVersionCollector(this.collectSupportData, paVersionDataCollectorConfiguration));
                    break;
                }
                case PA_SSL: {
                    DataCollectorConfiguration paSslDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PASslDataCollector(this.collectSupportData, paSslDataCollectorConfiguration));
                    break;
                }
                case PA_RUNTIME_CONFIG: {
                    DataCollectorConfiguration paRuntimeConfigCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new PARuntimeConfigDataCollector(this.collectSupportData, paRuntimeConfigCollectorConfiguration));
                    break;
                }
                case VISUALIZE_REPLICATION_STATE: {
                    DataCollectorConfiguration visualizeReplicationStateDataCollectorConfiguration = new DataCollectorConfiguration(dataCollectorConfiguration);
                    dataCollectors.add(new VisualizeReplicationStateDataCollector(this.collectSupportData, visualizeReplicationStateDataCollectorConfiguration));
                    break;
                }
                default: {
                    this.collectSupportData.log("No data collector found for type '" + (Object)((Object)collectorType) + "'");
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.collectSupportData.log("An error was encountered casting processing " + dataCollectorConfiguration.getId());
            if (e.getMessage().contains("DataCollectorType")) {
                String validValues = Arrays.stream(DataCollectorType.values()).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
                this.collectSupportData.log("Data collector type must be one of: " + validValues);
            }
            this.collectSupportData.log(e.toString());
        }
        return dataCollectors;
    }

    private List<ProcessDataCollector> getProcessDataCollectorsFromConfig(ProcessDataCollectorConfiguration processDataCollectorConfiguration) {
        ArrayList<ProcessDataCollector> processDataCollectors = new ArrayList<ProcessDataCollector>();
        if (processDataCollectorConfiguration.isValidConfiguration()) {
            if (processDataCollectorConfiguration.isExternalProcess()) {
                for (Integer pid : this.collectSupportData.additionalPids) {
                    processDataCollectors.add(new ProcessDataCollector(this.collectSupportData, processDataCollectorConfiguration, pid, null, true, false));
                }
            } else {
                File serverRoot = new File(this.collectSupportData.getServerRoot());
                processDataCollectors.add(new ProcessDataCollector(this.collectSupportData, processDataCollectorConfiguration, this.collectSupportData.getServerPID(serverRoot), null, true, false));
            }
        } else {
            this.collectSupportData.log(processDataCollectorConfiguration.getId() + " does not have a valid configuration.Please ensure that the required configuration is present: " + processDataCollectorConfiguration.getRequiredKeys());
        }
        return processDataCollectors;
    }

    public DataCollector getDataCollector(DataCollectorType collectorType, String name) {
        File serverRoot = new File(this.collectSupportData.getServerRoot());
        Integer pid = this.collectSupportData.getServerPID(serverRoot);
        DataCollector dataCollector = null;
        switch (collectorType) {
            case ROOT_ERR_FILE_LIST: {
                dataCollector = new FileListProcess(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, null, new File(this.collectSupportData.getServerRoot()), new ErrFileFilter(), null);
                break;
            }
            case ROOT_ERR_FILE_LIST_BY_LAST_MODIFIED: {
                dataCollector = new FileListProcess(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, null, new File(this.collectSupportData.getServerRoot()), new ErrFileFilter(), new CollectSupportData.LastModifiedComparator());
                break;
            }
            case ROOT_ERR_FILE_LIST_BY_SIZE: {
                dataCollector = new FileListProcess(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, null, new File(this.collectSupportData.getServerRoot()), new ErrFileFilter(), new CollectSupportData.FileSizeComparator());
                break;
            }
            case JAVA_IO_TMP_DIR_FILE_LIST: {
                String tmpDirName = System.getProperty("java.io.tmpdir");
                dataCollector = new FileListProcess(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, null, new File(tmpDirName), null);
                break;
            }
            case JPS: {
                dataCollector = new ProcessDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.JAVA, ProcessBuilderUtil.buildProcess(this.collectSupportData, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JPS), "-lvm"));
                break;
            }
            case JSTACK_SERVER_PID: {
                dataCollector = this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.SERVER, pid, true, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTACK), String.valueOf(pid));
                break;
            }
            case JSTACK_SERVER_PID_WITH_LOCKS: {
                dataCollector = this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.SERVER, pid, true, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTACK), "-l", String.valueOf(pid));
                break;
            }
            case JMAP_SERVER_PID: {
                dataCollector = this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.SERVER, pid, false, false, 3000000, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JMAP), "-histo:live", String.valueOf(pid));
                break;
            }
            case JINFO_SERVER_PID: {
                dataCollector = this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.SERVER, pid, false, false, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JINFO), String.valueOf(pid));
                break;
            }
            case JINFO64_SERVER_PID: {
                dataCollector = this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.SERVER, pid, false, false, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JINFO), "-d64", String.valueOf(pid));
                break;
            }
            case JSTAT_SERVER_PID: {
                dataCollector = this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.SERVER, pid, false, false, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTAT), "-gc", String.valueOf(pid), Integer.toString(this.collectSupportData.reportIntervalSeconds) + "s", Integer.toString(this.collectSupportData.reportCount));
                break;
            }
            case UNIX_FULL_SERVER_ROOT: {
                dataCollector = new ProcessDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.LS, "-alRF", this.collectSupportData.getServerRoot()));
                break;
            }
            case FULL_SERVER_ROOT: {
                dataCollector = new ProcessDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.CMD, "/C", "dir", "/S", "/Q", this.collectSupportData.getServerRoot()));
                break;
            }
            case SERVER_ROOT_ACLS: {
                dataCollector = new ProcessDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.CACLS, this.collectSupportData.getServerRoot(), "/T", "/C"));
                break;
            }
            case EXTENSIONS_LIST: {
                String manageExtension = OperatingSystem.isUNIXBased(OperatingSystem.forName(System.getProperty("os.name"))) ? new File(serverRoot, "bin/manage-extension").getAbsolutePath() : new File(serverRoot, "bat/manage-extension.bat").getAbsolutePath();
                dataCollector = new ProcessDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.SERVER, ProcessBuilderUtil.buildProcess(this.collectSupportData, manageExtension, "--list"));
                break;
            }
            case JAR_MANIFEST: {
                dataCollector = new JarManifestCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.SERVER_ROOT_FILES, null, new File(serverRoot, "lib"));
                break;
            }
            case MONITOR_LDAP_SEARCH: {
                if (!this.collectSupportData.ldapEnabled()) break;
                try {
                    SearchRequest monitorReq = new SearchRequest("cn=monitor", SearchScope.SUB, "objectclass=*", new String[0]);
                    dataCollector = new LdapSearchDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.LDAP, null, this.collectSupportData.createLdapConnection(true), monitorReq, true);
                }
                catch (LDAPException ldape) {
                    this.collectSupportData.log("Failed to create search request for cn=monitor", ldape);
                }
                break;
            }
            case ROOT_LDAP_SEARCH: {
                if (!this.collectSupportData.ldapEnabled()) break;
                try {
                    SearchRequest rootdseReq = new SearchRequest("", SearchScope.BASE, "objectclass=*", new String[]{"+"});
                    dataCollector = new LdapSearchDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.LDAP, null, this.collectSupportData.createLdapConnection(true), rootdseReq, true);
                }
                catch (LDAPException ldape) {
                    this.collectSupportData.log("Failed to create search request for root DSE", ldape);
                }
                break;
            }
            case LDAP_STATUS: {
                if (OperatingSystem.isUNIXBased(this.os)) {
                    dataCollector = new LDAPCommandDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.LDAP, null, new File(serverRoot, "bin/status"), "--noPropertiesFile");
                    break;
                }
                dataCollector = new LDAPCommandDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.LDAP, null, new File(serverRoot, "bat/status.bat"), "--noPropertiesFile");
                break;
            }
            case DUMP_REPLICATION_STATE: {
                if (!this.collectSupportData.ldapEnabled() || !this.collectSupportData.collectReplicationStateDump) break;
                dataCollector = new DumpReplicationStateTaskWrapper(this.collectSupportData, name, CollectSupportData.ZipParentPath.LDAP, null);
                break;
            }
            case CONFIG_DIFF_POST_SETUP: {
                dataCollector = new ConfigDiffPostSetupDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.CONFIG_DIFF, null);
                break;
            }
            case CONFIG_DIFF_BASELINE: {
                dataCollector = new ConfigDiffBaselineDataCollector(this.collectSupportData, name, CollectSupportData.ZipParentPath.CONFIG_DIFF, null);
                break;
            }
            default: {
                this.collectSupportData.log("No data collector found for type " + (Object)((Object)collectorType));
            }
        }
        return dataCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataCollector> getDataCollectors(DataCollectorType collectorType, String name) throws Exception {
        ArrayList<DataCollector> dataCollectors = new ArrayList<DataCollector>();
        switch (collectorType) {
            case EXTERNAL_DIR_FILE_LIST: {
                for (File externalServerDir : this.collectSupportData.getExternalServerDirs()) {
                    String path = externalServerDir.getPath();
                    if (path.startsWith(File.separator)) {
                        path = name.substring(File.separator.length());
                    }
                    path = path.replaceAll(Matcher.quoteReplacement(File.separator), "_");
                    dataCollectors.add(new FileListProcess(this.collectSupportData, path, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, null, new File(path), null));
                }
                break;
            }
            case JSTACK_ADDITIONAL_PIDS: {
                for (Integer pid : this.collectSupportData.additionalPids) {
                    dataCollectors.add(this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, pid, true, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTACK), String.valueOf(pid)));
                }
                break;
            }
            case JINFO_ADDITIONAL_PIDS: {
                for (Integer pid : this.collectSupportData.additionalPids) {
                    dataCollectors.add(this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, pid, false, false, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JINFO), String.valueOf(pid)));
                }
                break;
            }
            case JINFO64_ADDITIONAL_PIDS: {
                for (Integer pid : this.collectSupportData.additionalPids) {
                    dataCollectors.add(this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, pid, false, false, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JINFO), "-d64", String.valueOf(pid)));
                }
                break;
            }
            case JSTAT_ADDITIONAL_PIDS: {
                for (Integer pid : this.collectSupportData.additionalPids) {
                    dataCollectors.add(this.createProcessDataCollectorForPid(name, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, pid, false, false, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTAT), "-gc", String.valueOf(pid), "1s", "10"));
                }
                break;
            }
            case EXTERNAL_UNIX_FULL_SERVER_ROOT: {
                if (!OperatingSystem.isUNIXBased(this.os)) break;
                for (File externalServerDir : this.collectSupportData.getExternalServerDirs()) {
                    String path = externalServerDir.getPath();
                    if (path.startsWith(File.separator)) {
                        path = path.substring(File.separator.length());
                    }
                    path = path.replaceAll(Matcher.quoteReplacement(File.separator), "_");
                    dataCollectors.add(new ProcessDataCollector(this.collectSupportData, name + path, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.LS, "-alRF", externalServerDir.getCanonicalPath())));
                }
                break;
            }
            case EXTERNAL_FULL_SERVER_ROOT: {
                if (OperatingSystem.isUNIXBased(this.os)) break;
                for (File externalServerDir : this.collectSupportData.getExternalServerDirs()) {
                    String path = externalServerDir.getPath();
                    if (path.startsWith(File.separator)) {
                        path = path.substring(File.separator.length());
                    }
                    path = path.replaceAll(Matcher.quoteReplacement(File.separator), "_");
                    dataCollectors.add(new ProcessDataCollector(this.collectSupportData, name + path, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.CMD, "/C", "dir", "/S", "/Q", externalServerDir.getCanonicalPath())));
                }
                break;
            }
            case EXTERNAL_SERVER_ROOT_ACLS: {
                if (OperatingSystem.isUNIXBased(this.os)) break;
                for (File externalServerDir : this.collectSupportData.getExternalServerDirs()) {
                    String path = externalServerDir.getPath();
                    if (path.startsWith(File.separator)) {
                        path = path.substring(File.separator.length());
                    }
                    path = path.replaceAll(Matcher.quoteReplacement(File.separator), "_");
                    dataCollectors.add(new ProcessDataCollector(this.collectSupportData, path + name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.CACLS, externalServerDir.getCanonicalPath(), "/T", "/C")));
                }
                break;
            }
            case FILE_LIST: {
                String tmpDirName = System.getProperty("java.io.tmpdir");
                File tmpDir = new File(tmpDirName);
                Set<File> extServerDirs = this.collectSupportData.getExternalServerDirs();
                if (!extServerDirs.isEmpty() && extServerDirs.contains(tmpDir)) break;
                dataCollectors.add(new FileListProcess(this.collectSupportData, name, CollectSupportData.ZipParentPath.DIRECTORY_LISTINGS, null, tmpDir, null, null));
                break;
            }
            case LOCAL_DB_ACI_LDAP_SEARCH: {
                if (!this.collectSupportData.ldapEnabled() || this.collectSupportData.securityLevel == SecurityLevel.MAXIMUM) break;
                try {
                    List<Entry> localDBBackends = LDIFUtils.getEntriesMatchingObjectClass(new File(this.collectSupportData.getServerRoot() + File.separator + "config" + File.separator + "config.ldif").getAbsolutePath(), LDIFUtils.LOCAL_DB_BACKEND, new String[0]);
                    for (Entry backend : localDBBackends) {
                        String backendId = backend.getAttributeValue(LDIFUtils.BACKEND_ID);
                        for (String baseDN : backend.getAttributeValues(LDIFUtils.BASE_DN)) {
                            SearchRequest aciReq = new SearchRequest(baseDN, SearchScope.SUB, "aci=*", new String[]{"aci"});
                            aciReq.setSizeLimit(100);
                            baseDN = baseDN.replaceAll("[=,]", "_");
                            dataCollectors.add(new LdapSearchDataCollector(this.collectSupportData, String.format("%s-%s-acis.ldif", backendId, baseDN), CollectSupportData.ZipParentPath.LDAP, null, this.collectSupportData.createLdapConnection(true), aciReq, true));
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    this.collectSupportData.log("Failed to execute LDAP Search for Local DB ACIs", e);
                    break;
                }
            }
            case NOTIFICATION_MANAGER_LDAP_SEARCH: {
                if (!this.collectSupportData.ldapEnabled() || this.collectSupportData.securityLevel == SecurityLevel.MAXIMUM) break;
                try {
                    List<Entry> notificationManagers = LDIFUtils.getEntriesMatchingObjectClass(new File(this.collectSupportData.getServerRoot() + File.separator + "config" + File.separator + "config.ldif").getAbsolutePath(), LDIFUtils.NOTIFICATION_MANAGER, new String[0]);
                    for (Entry manager : notificationManagers) {
                        String baseDN = manager.getAttributeValue(LDIFUtils.SUBSCRIPTION_BASE_DN);
                        SearchRequest notificationStateRequest = new SearchRequest(baseDN, SearchScope.SUB, "(&)", new String[]{"*", "+"});
                        String fileName = String.format("notification-manager-state-%s.ldif", manager.getAttributeValue(LDIFUtils.CN).replace(' ', '_'));
                        dataCollectors.add(new LdapSearchDataCollector(this.collectSupportData, fileName, CollectSupportData.ZipParentPath.LDAP, null, this.collectSupportData.createLdapConnection(true), notificationStateRequest, true));
                    }
                    break;
                }
                catch (Exception e) {
                    this.collectSupportData.log("Failed to execute LDAP Search on Notification Managers", e);
                    break;
                }
            }
            case REPLICATION_DOMAIN_LDAP_SEARCH: {
                if (!this.collectSupportData.ldapEnabled() || this.collectSupportData.securityLevel == SecurityLevel.MAXIMUM) break;
                LDAPInterface adminSession = this.collectSupportData.createLdapConnection(true);
                try {
                    SearchRequest cfgRequest = new SearchRequest("cn=config", SearchScope.SUB, "objectClass=ds-cfg-replication-domain", new String[]{"ds-cfg-base-dn"});
                    SearchResult res = adminSession.search(cfgRequest);
                    for (SearchResultEntry entry : res.getSearchEntries()) {
                        String baseDN = entry.getAttributeValue(LDIFUtils.BASE_DN);
                        SearchRequest searchRequest = new SearchRequest(baseDN, SearchScope.BASE, "(&)", new String[]{"ds-sync-state", "ds-sync-state-detail", "ds-sync-generation-id", "ds-sync-conflict", "entryUUID", "createTimestamp", "modifyTimestamp"});
                        String fileName = String.format("replication-domain-%s.ldif", baseDN.replace(' ', '_'));
                        dataCollectors.add(new LdapSearchDataCollector(this.collectSupportData, fileName, CollectSupportData.ZipParentPath.LDAP, null, this.collectSupportData.createLdapConnection(true), searchRequest, true));
                    }
                    break;
                }
                catch (Exception e) {
                    this.collectSupportData.log("Failed to execute LDAP Search on Replication Domains", e);
                    break;
                }
                finally {
                    if (adminSession instanceof LDAPConnection) {
                        AdminSessionUtils.endSession((LDAPConnection)adminSession);
                    }
                }
            }
            case METRICS_ENGINE_SUPPORT: {
                for (ExternalCollectorTask task : MetricsEngineUtils.getSupportDataCollectors(CollectSupportData.ZipParentPath.METRICS_DBMS, this.collectSupportData)) {
                    dataCollectors.add(new ExternalCollectorTaskWrapper(this.collectSupportData, task));
                }
                break;
            }
            case METRICS_ENGINE_COMMANDS: {
                for (String[] cmds : MetricsEngineUtils.getCommandsToExecute(this.collectSupportData)) {
                    String[] realCmds = new String[cmds.length - 1];
                    System.arraycopy(cmds, 1, realCmds, 0, realCmds.length);
                    dataCollectors.add(new ProcessDataCollector(this.collectSupportData, cmds[0], CollectSupportData.ZipParentPath.METRICS_DBMS, null, null, (Boolean)false, (Boolean)false, (Boolean)true, ProcessBuilderUtil.buildProcess(this.collectSupportData, realCmds)));
                }
                break;
            }
            case METRICS_ENGINE_DIRECTORIES: {
                for (File dir : MetricsEngineUtils.getDirectoriesToList(this.collectSupportData)) {
                    dataCollectors.add(new ProcessDataCollector(this.collectSupportData, dir.getName(), CollectSupportData.ZipParentPath.METRICS_DBMS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.LS, "-alRF", dir.getAbsolutePath())));
                }
                break;
            }
            case METRICS_ENGINE_FILES: {
                for (File file : MetricsEngineUtils.getFilesToCat(this.collectSupportData)) {
                    dataCollectors.add(new ProcessDataCollector(this.collectSupportData, file.getName(), CollectSupportData.ZipParentPath.METRICS_DBMS, ProcessBuilderUtil.buildProcess(this.collectSupportData, Command.CAT, file.getAbsolutePath())));
                }
                break;
            }
            default: {
                this.collectSupportData.log("No data collector found for type " + (Object)((Object)collectorType));
            }
        }
        return dataCollectors;
    }

    private DataCollector createProcessDataCollectorForPid(String name, CollectSupportData.ZipParentPath zipParentPath, Integer pid, boolean filterOutput, boolean repeating, Integer outputLimit, String ... command) {
        return new ProcessDataCollector(this.collectSupportData, name, zipParentPath, pid, null, (Boolean)repeating, (Boolean)filterOutput, (Boolean)false, outputLimit, ProcessBuilderUtil.buildProcess(this.collectSupportData, command));
    }

    private DataCollector createProcessDataCollectorForPid(String name, CollectSupportData.ZipParentPath zipParentPath, Integer pid, boolean filterOutput, boolean repeating, String ... command) {
        return this.createProcessDataCollectorForPid(name, zipParentPath, pid, filterOutput, repeating, 1000000, command);
    }

    private DataCollector createProcessDataCollectorForPid(String name, CollectSupportData.ZipParentPath zipParentPath, Integer pid, boolean filterOutput, String ... command) {
        return this.createProcessDataCollectorForPid(name, zipParentPath, pid, filterOutput, true, command);
    }
}

