/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.mon.util.Utils;
import com.pingidentity.csd.server.datacollector.config.MessageDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.util.FutureCondition;
import com.unboundid.common.util.FileUtils;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskState;
import com.unboundid.messages.Message;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;

public class DumpReplicationStateTaskWrapper
extends DataCollectorTask {
    private CollectSupportData collectSupportData;
    private final String taskDN;
    private final LDAPInterface connection;
    private PrintStream printStream = null;
    private File tempFile = null;

    public DumpReplicationStateTaskWrapper(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        String taskID = "dump" + System.currentTimeMillis();
        this.taskDN = "ds-task-id=" + taskID + ",cn=scheduled tasks,cn=tasks";
        this.connection = collectSupportData.createLdapConnection(true);
        try {
            this.printStream = new PrintStream((OutputStream)this.commandOutput, true, "UTF-8");
            File tempFile = File.createTempFile("DumpState", ".xml");
            tempFile.deleteOnExit();
            this.tempFile = tempFile;
            this.connection.add(new String[]{"dn: " + this.taskDN, "objectClass: ds-dump-replication-state-task", "objectClass: ds-task", "objectClass: top", "ds-task-id: " + taskID, "ds-task-class-name: com.unboundid.directory.server.tasks.DumpReplicationStateTask", "ds-task-dump-replication-state-file: " + tempFile.getAbsolutePath()});
        }
        catch (Exception e) {
            if (this.printStream != null) {
                this.printStream.append("Failed to create dump replication state task");
                this.printStream.append(CollectSupportData.EOL);
            }
            PrintStream ps = new PrintStream(new ByteArrayOutputStream());
            e.printStackTrace(ps);
            collectSupportData.log("Failed to create dump replication state task: " + ps.toString());
        }
    }

    public DumpReplicationStateTaskWrapper(CollectSupportData collectSupportData, MessageDataCollectorConfiguration messageDataCollectorConfiguration) {
        this(collectSupportData, messageDataCollectorConfiguration.getId(), messageDataCollectorConfiguration.getZipParentPathAsEnum(), messageDataCollectorConfiguration.getMessage());
    }

    @Override
    protected void writeData() throws Exception {
        try {
            final TaskState[] taskState = new TaskState[]{TaskState.UNSCHEDULED};
            boolean taskComplete = Utils.execFutureCondition(new FutureCondition(100, 100){

                @Override
                public boolean testCondition() {
                    try {
                        SearchResultEntry entry = DumpReplicationStateTaskWrapper.this.connection.getEntry(DumpReplicationStateTaskWrapper.this.taskDN, new String[]{"ds-task-state"});
                        taskState[0] = Enum.valueOf(TaskState.class, entry.getAttributeValue("ds-task-state"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return DumpReplicationStateTaskWrapper.this.isDone(taskState[0]);
                }
            });
            if (taskComplete && this.isSuccessful(taskState[0])) {
                FileUtils.writeContents((OutputStream)this.printStream, (File)this.tempFile);
                this.printStream.append(CollectSupportData.EOL);
            } else {
                this.printStream.append("Task " + this.taskDN + " left in unsuccessful state: " + taskState[0]);
            }
        }
        catch (Exception e) {
            this.printStream.append("Failed to get dumped replication state from " + this.tempFile.getAbsolutePath());
            this.printStream.append(CollectSupportData.EOL);
            this.collectSupportData.log("Failed to get dumped replication state: " + e.toString());
        }
    }

    private boolean isDone(TaskState taskState) {
        switch (taskState) {
            case DISABLED: 
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    public boolean isSuccessful(TaskState taskState) {
        if (!this.isDone(taskState)) {
            return false;
        }
        switch (taskState) {
            case COMPLETED_SUCCESSFULLY: 
            case COMPLETED_WITH_ERRORS: {
                return true;
            }
        }
        return false;
    }
}

