/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class FileDataCollector
extends DataCollectorTask {
    private Map<String, FileInfo> allFileData;
    private String baseDir;
    static final char[] hexArray = "0123456789abcdef".toCharArray();

    public FileDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.baseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        this.writeln("<fileData>");
        this.allFileData = new TreeMap<String, FileInfo>();
        this.log("Starting to collect file data from path " + this.baseDir);
        FileInfo rootFileInfo = new FileInfo(this.baseDir);
        this.allFileData.put(rootFileInfo.getCanonicalPath(), rootFileInfo);
        if (rootFileInfo.isFolder()) {
            this.processFolder(this.baseDir);
        }
        if (this.allFileData != null) {
            for (FileInfo tmpFileInfo : this.allFileData.values()) {
                this.write(tmpFileInfo.toXML());
            }
        }
        this.writeln("</fileData>");
    }

    private void processFolder(String folderPath) {
        File f = new File(folderPath);
        String[] children = f.list();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            String tmpFilename = children[i];
            if (tmpFilename.equals(".") || tmpFilename.equals("..")) continue;
            String childPath = folderPath + File.separator + tmpFilename;
            FileInfo childInfo = null;
            try {
                childInfo = new FileInfo(childPath);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.log("ERROR: Unable to collect file/folder information for " + childPath, e);
                continue;
            }
            if (childInfo == null) continue;
            if (this.allFileData.containsKey(childInfo.getCanonicalPath())) {
                this.log(childPath + "(canonical path=" + childInfo.getCanonicalPath() + ")' was already processed as '" + this.allFileData.get(childInfo.getCanonicalPath()).getPath() + "'. Not processing it again. This is probably caused by a symbolic link between folders creating a loop.");
                continue;
            }
            this.allFileData.put(childInfo.getCanonicalPath(), childInfo);
            if (!childInfo.isFolder()) continue;
            this.processFolder(childPath);
        }
    }

    private static String convertToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static class FileInfo {
        private String path;
        private String absolutePath;
        private long fileSize;
        private Date lastModified;
        private Date created;
        private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private String md5Sum;
        private boolean folder;
        private boolean symlink;
        private boolean regularFile;
        private boolean readable;
        private boolean writable;
        private boolean executable;
        private String canonicalPath;

        public FileInfo() {
        }

        public FileInfo(String filePath) throws IOException, NoSuchAlgorithmException {
            this.path = filePath;
            File f = new File(filePath);
            this.absolutePath = f.getAbsolutePath();
            if (f.isDirectory()) {
                this.folder = true;
            }
            if (f.isFile()) {
                this.regularFile = true;
                this.fileSize = f.length();
                this.md5Sum = this.md5Sum(f);
            }
            this.symlink = this.isSymlink(f);
            this.lastModified = new Date(f.lastModified());
            this.readable = f.canRead();
            this.executable = f.canExecute();
            this.writable = f.canWrite();
        }

        private String md5Sum(File f) throws NoSuchAlgorithmException, IOException {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            FileInputStream instream = new FileInputStream(f);
            DigestInputStream dis = new DigestInputStream(instream, md5);
            byte[] buffer = new byte[8192];
            int bytesRead = 1;
            while ((bytesRead = dis.read(buffer)) != -1) {
            }
            dis.close();
            byte[] digest = md5.digest();
            String hexDigest = FileDataCollector.convertToHex(digest);
            return hexDigest;
        }

        private boolean isSymlink(File file) throws IOException {
            File canon;
            if (file == null) {
                throw new NullPointerException("File must not be null");
            }
            if (file.getParent() == null) {
                canon = file;
            } else {
                File canonDir = file.getParentFile().getCanonicalFile();
                canon = new File(canonDir, file.getName());
            }
            File canonicalFile = canon.getCanonicalFile();
            boolean isSymbolicLink = !canonicalFile.equals(canon.getAbsoluteFile());
            this.canonicalPath = canonicalFile.getPath();
            return isSymbolicLink;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public Date getCreated() {
            return this.created;
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        public String getMd5Sum() {
            return this.md5Sum;
        }

        public void setMd5Sum(String md5Sum) {
            this.md5Sum = md5Sum;
        }

        public boolean isFolder() {
            return this.folder;
        }

        public void setFolder(boolean folder) {
            this.folder = folder;
        }

        public boolean isSymlink() {
            return this.symlink;
        }

        public void setSymlink(boolean symlink) {
            this.symlink = symlink;
        }

        public boolean isRegularFile() {
            return this.regularFile;
        }

        public void setRegularFile(boolean regularFile) {
            this.regularFile = regularFile;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public void setReadable(boolean readable) {
            this.readable = readable;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean writable) {
            this.writable = writable;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        public void setExecutable(boolean executable) {
            this.executable = executable;
        }

        public String getCanonicalPath() {
            return this.canonicalPath;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("absolutePath:'" + this.absolutePath + "',");
            sb.append("fileSize:'" + this.fileSize + "',");
            sb.append("md5Sum:'" + this.md5Sum + "',");
            sb.append("path:'" + this.path + "',");
            sb.append("created:'" + this.created + "',");
            sb.append("executable:'" + this.executable + "',");
            sb.append("folder:'" + this.folder + "',");
            sb.append("lastModified:'" + this.lastModified + "',");
            sb.append("readable:'" + this.readable + "',");
            sb.append("regularFile:'" + this.regularFile + "',");
            sb.append("symlink:'" + this.symlink);
            if (this.symlink) {
                sb.append("->");
                sb.append(this.canonicalPath);
                sb.append("',");
            } else {
                sb.append("',");
            }
            sb.append("writable:'" + this.writable + "'");
            return sb.toString();
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<FileInfo>\r\n");
            sb.append("\t<absolutePath>" + this.absolutePath + "</absolutePath>\r\n");
            sb.append("\t<fileSize>" + this.fileSize + "</fileSize>\r\n");
            sb.append("\t<md5Sum>" + this.md5Sum + "</md5Sum>\r\n");
            sb.append("\t<path>" + this.path + "</path>\r\n");
            sb.append("\t<created>" + (this.created == null ? "" : this.dateFormat.format(this.created)) + "</created>\r\n");
            sb.append("\t<executable>" + this.executable + "</executable>\r\n");
            sb.append("\t<folder>" + this.folder + "</folder>\r\n");
            sb.append("\t<lastModified>" + (this.lastModified == null ? "" : this.dateFormat.format(this.lastModified)) + "</lastModified>\r\n");
            sb.append("\t<readable>" + this.readable + "</readable>\r\n");
            sb.append("\t<regularFile>" + this.regularFile + "</regularFile>\r\n");
            sb.append("\t<symlink>" + this.symlink + "</symlink>\r\n");
            sb.append("\t<writable>" + this.writable + "</writable>\r\n");
            sb.append("\t<canonicalPath>" + this.canonicalPath + "</canonicalPath>\r\n");
            sb.append("</FileInfo>\r\n");
            return sb.toString();
        }
    }
}

