/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.MessageDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.messages.Message;
import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.comparator.NameFileComparator;

public class FileListProcess
extends DataCollectorTask {
    private CollectSupportData collectSupportData;
    private File root;
    private FileFilter trackedFileFilter;
    private Comparator<File> comparator = new NameFileComparator();
    private final Set<File> foundTrackedFiles = new HashSet<File>();
    private final DateFormat flDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'");
    private long totalSize;
    private final String COL_SEP = "  ";
    private final List<File> files = new ArrayList<File>();

    @Override
    public String getCommand() {
        return "file list";
    }

    public FileListProcess(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, File root, FileFilter trackedFileFilter) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        this.root = root;
        this.trackedFileFilter = trackedFileFilter != null ? trackedFileFilter : new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return false;
            }
        };
        this.flDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public FileListProcess(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, File root, FileFilter trackedFileFilter, Comparator<File> comparator) {
        this(collectSupportData, name, zipParent, message, root, trackedFileFilter);
        this.comparator = comparator;
    }

    public FileListProcess(CollectSupportData collectSupportData, MessageDataCollectorConfiguration messageDataCollectorConfiguration, FileFilter fileFilter) {
        this(collectSupportData, messageDataCollectorConfiguration.getId(), messageDataCollectorConfiguration.getZipParentPathAsEnum(), messageDataCollectorConfiguration.getMessage(), new File(collectSupportData.getServerRoot()), fileFilter);
    }

    public FileListProcess(CollectSupportData collectSupportData, MessageDataCollectorConfiguration messageDataCollectorConfiguration) {
        this(collectSupportData, messageDataCollectorConfiguration, null);
    }

    public Set<File> getTrackedFiles() {
        return this.foundTrackedFiles;
    }

    @Override
    protected void writeData() throws Exception {
        this.write(this.root.getCanonicalPath());
        this.write(CollectSupportData.EOL);
        this.visit(this.root);
        if (this.comparator != null) {
            Collections.sort(this.files, this.comparator);
        }
        this.writeRecords();
    }

    private void visit(File f) throws Exception {
        this.totalSize += f.length();
        if (this.trackedFileFilter.accept(f)) {
            this.foundTrackedFiles.add(f);
        }
        this.files.add(f);
        Object[] children = f.listFiles();
        if (children != null) {
            if (this.comparator == null) {
                Arrays.sort(children);
            }
            for (Object child : children) {
                this.visit((File)child);
            }
        }
    }

    private void writeRecords() throws Exception {
        this.write("total files: ");
        this.write(Integer.toString(this.files.size()));
        this.write(CollectSupportData.EOL);
        String totalSizeStr = Long.toString(this.totalSize);
        for (File f : this.files) {
            String name = f.getName();
            if (f.getParent() != null) {
                name = f.getParent() + File.separator + f.getName();
            }
            name = name.replace(this.root.toString(), ".");
            String fileSizeStr = Long.toString(f.length());
            String lastModifiedStr = this.flDateFormat.format(f.lastModified());
            this.write(" ");
            char[] blankArray = new char[totalSizeStr.length() - fileSizeStr.length()];
            Arrays.fill(blankArray, ' ');
            this.write(new String(blankArray));
            this.write(fileSizeStr);
            this.write("  ");
            this.write(lastModifiedStr);
            this.write("  ");
            this.write(name);
            this.write(CollectSupportData.EOL);
        }
        this.write(" ");
        char[] dashArray = new char[totalSizeStr.length()];
        Arrays.fill(dashArray, '-');
        this.write(new String(dashArray));
        this.write("                    ------");
        this.write(CollectSupportData.EOL);
        this.write(" ");
        this.write(Long.toString(this.totalSize));
        this.write("  ");
        this.write("                 ");
        this.write(Integer.toString(this.files.size()));
        this.write(" files");
        this.write(CollectSupportData.EOL);
        if (this.message == null) {
            this.message = QuickSetupMessages.INFO_PROGRESS_DONE.get();
        }
    }
}

