/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.metrics;

import com.pingidentity.csd.server.datacollector.task.ExternalCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.directory.mon.core.Context;
import com.unboundid.messages.Message;
import java.io.IOException;

public class DbmsTableDataCollector
extends ExternalCollectorTask {
    private final String tableName;
    private static int MAX_TABLE_RECORDS = 10000;

    public DbmsTableDataCollector(String name, CollectSupportData.ZipParentPath parent, Message message, String tableName) {
        super(name, parent, message);
        this.tableName = tableName;
    }

    @Override
    protected void writeData() throws IOException {
        try {
            int maxRecords = MAX_TABLE_RECORDS;
            if ("metric_qualifier".equals(this.tableName)) {
                maxRecords = MAX_TABLE_RECORDS * 4;
            }
            Context ctx = Context.find(null);
            ctx.getDBMaintenance().dump(this.tableName, this.getOutputStream(), maxRecords, null);
        }
        catch (Exception e) {
            e.printStackTrace(this.getOutputStream());
        }
    }
}

