/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pf;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.XMLOutput;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PFCertificateDataCollector
extends DataCollectorTask {
    private String pfBaseDir;
    private String keytoolCommand;
    private Map<String, String> jksData;

    public PFCertificateDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.pfBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        this.keytoolCommand = this.getKeytoolCommand();
        if (this.keytoolCommand != null) {
            this.write("<certificateData>");
            this.collectData();
            if (this.jksData != null) {
                for (String jksFile : this.jksData.keySet()) {
                    this.write("<" + jksFile + ">");
                    this.write(XMLOutput.escapeXML(this.jksData.get(jksFile)));
                    this.write("</" + jksFile + ">\r\n");
                }
            }
            this.write("</certificateData>");
        } else {
            this.write("There was a problem collecting certificate data.");
        }
    }

    private String getKeytoolCommand() {
        String jdkBinDirPath = this.collectSupportData.getJdkBinDirPath();
        String keytoolPath = jdkBinDirPath + "keytool";
        File keytoolFile = new File(keytoolPath);
        if (keytoolFile.exists()) {
            return keytoolPath;
        }
        keytoolPath = jdkBinDirPath + "keytool.exe";
        keytoolFile = new File(keytoolPath);
        if (keytoolFile.exists()) {
            return keytoolPath;
        }
        this.log("Key tool could not be found at " + keytoolPath);
        return null;
    }

    public void collectData() {
        this.jksData = new HashMap<String, String>();
        Properties jksFileExtensionsList = new Properties();
        String[] jksFileExtensions = new String[]{".jks", ".hsmks"};
        try {
            String serverDefaultDataPath = this.pfBaseDir + File.separator + "server" + File.separator + "default" + File.separator + "data";
            File serverDefaultDataFolder = new File(serverDefaultDataPath);
            if (!serverDefaultDataFolder.isDirectory()) {
                this.log("'" + serverDefaultDataPath + "' is not a directory. Cannot collect certificate data.");
            } else {
                File[] serverDefaultDataFolderEntries = serverDefaultDataFolder.listFiles();
                if (serverDefaultDataFolderEntries == null) {
                    this.log("No entries found in '" + serverDefaultDataPath + "'");
                } else {
                    for (File file : serverDefaultDataFolderEntries) {
                        List<String> list = Arrays.asList(jksFileExtensions);
                        if (!list.stream().anyMatch(ex -> file.getName().endsWith((String)ex))) continue;
                        String jksListResults = this.keytoolListRfc(file.getPath());
                        this.jksData.put(file.getName(), jksListResults);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log("Error processing keystore files", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String keytoolListRfc(String keystorePath) {
        try {
            String tmpStrFromStdErr;
            String tmpStrFromStdOut;
            String[] cmdArray = new String[]{this.keytoolCommand, "-list", "-rfc", "-keystore", keystorePath};
            Process p = Runtime.getRuntime().exec(cmdArray);
            StringBuilder sbStdErr = new StringBuilder();
            StringBuilder sbStdOut = new StringBuilder();
            InputStreamReader inStreamReader = new InputStreamReader(p.getInputStream());
            BufferedReader stdInput = new BufferedReader(inStreamReader);
            BufferedWriter stdOutput = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            InputStreamReader inErrorStremReader = new InputStreamReader(p.getErrorStream());
            BufferedReader stdError = new BufferedReader(inErrorStremReader);
            char[] buffer = new char[24];
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Integer> future = executor.submit(() -> inErrorStremReader.read(buffer));
            try {
                if (future.get(5L, TimeUnit.SECONDS) > -1) {
                    String tmpStr = new String(buffer);
                    if ("Enter keystore password:".equalsIgnoreCase(tmpStr)) {
                        stdOutput.newLine();
                        stdOutput.flush();
                    } else {
                        sbStdOut.append(tmpStr);
                    }
                }
            }
            catch (TimeoutException e) {
                future.cancel(true);
            }
            finally {
                executor.shutdown();
            }
            while ((tmpStrFromStdOut = stdInput.readLine()) != null) {
                sbStdOut.append(tmpStrFromStdOut);
                sbStdOut.append("\r\n");
            }
            while ((tmpStrFromStdErr = stdError.readLine()) != null) {
                sbStdErr.append(tmpStrFromStdErr);
            }
            return sbStdOut.toString();
        }
        catch (Exception ex) {
            this.log("Error running keytool command", ex);
            return null;
        }
    }
}

