/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.unboundid.csd.messages.UBIDCoreMessages;
import com.unboundid.directory.server.util.Validator;

public class FixedSizeAppender
implements Appendable {
    private StringBuilder buff;
    private StringBuilder prevBuff;
    private int size;
    private final int sizeBound;

    public int length() {
        if (this.size > this.sizeBound) {
            return this.sizeBound;
        }
        return this.buff.length();
    }

    public int getTotalSize() {
        return this.size;
    }

    public FixedSizeAppender(int bound) {
        this.sizeBound = bound;
        this.buff = new StringBuilder(this.sizeBound);
        this.prevBuff = new StringBuilder(this.sizeBound);
        this.size = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.size > this.sizeBound) {
            sb.append(UBIDCoreMessages.INFO_TRUNCATE_FILE_MESSAGE.get(this.sizeBound, this.size));
        }
        sb.append(this.getRawString());
        return sb.toString();
    }

    @Override
    public Appendable append(CharSequence csq) {
        int appendLen;
        if (csq == null) {
            return this;
        }
        int inputLength = csq.length();
        for (int startIdx = 0; startIdx < inputLength; startIdx += appendLen) {
            if (this.buff.length() == this.sizeBound) {
                this.prevBuff.setLength(0);
                StringBuilder tmp = this.prevBuff;
                this.prevBuff = this.buff;
                this.buff = tmp;
            }
            appendLen = Math.min(inputLength - startIdx, this.sizeBound - this.buff.length());
            this.buff.append(csq.subSequence(startIdx, startIdx + appendLen));
        }
        this.size += inputLength;
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        if (csq == null) {
            return this;
        }
        Validator.ensureTrue((start >= 0 && start <= end && end <= csq.length() ? 1 : 0) != 0);
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public Appendable append(char c) {
        return this.append(String.valueOf(c));
    }

    public String getRawString() {
        if (this.size > this.sizeBound) {
            StringBuilder builder = new StringBuilder(this.sizeBound);
            builder.append(this.prevBuff.substring(this.buff.length()));
            builder.append((CharSequence)this.buff);
            return builder.toString();
        }
        return this.prevBuff.toString() + this.buff.toString();
    }
}

