/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import com.unboundid.common.types.DurationUnit;

public abstract class FutureCondition {
    public static final int DEFAULT_TIME_BETWEEN_TESTS_MS = 100;
    public static final int DEFAULT_MAX_ATTEMPTS = 100;
    public static final int DEFAULT_MAX_TIME_MS = 10000;
    private final int timeBetweenTestsMS;
    private final int maxAttempts;
    private final int maxTimeMS;

    public FutureCondition() {
        this(100, 100, 10000);
    }

    public FutureCondition(int timeBetweenTestsMS) {
        this(timeBetweenTestsMS, 100);
    }

    public FutureCondition(String maxDuration) {
        this(100, (int)(DurationUnit.parseValue((String)maxDuration) / 100L), (int)DurationUnit.parseValue((String)maxDuration));
    }

    public FutureCondition(int timeBetweenTestsMS, int maxAttempts) {
        this(timeBetweenTestsMS, maxAttempts, timeBetweenTestsMS * maxAttempts);
    }

    public FutureCondition(int timeBetweenTestsMS, int maxAttempts, int maxTimeMS) {
        this.validatorEnsureTrue(timeBetweenTestsMS > 0, "Time between tests must be positive");
        this.validatorEnsureTrue(maxAttempts > 0, "Maximum attempts must be positive");
        this.validatorEnsureTrue(maxTimeMS > 0, "Maximum time must be positive");
        this.timeBetweenTestsMS = timeBetweenTestsMS;
        this.maxAttempts = maxAttempts;
        this.maxTimeMS = maxTimeMS;
    }

    public final int getTimeBetweenTestsMS() {
        return this.timeBetweenTestsMS;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final int getMaxTimeMS() {
        return this.maxTimeMS;
    }

    public final String toString() {
        return String.format("Class: %s, time between tests: %d ms, max attempts: %d.  %s", this.getClass(), this.getTimeBetweenTestsMS(), this.getMaxAttempts(), this.getConditionDetails());
    }

    protected String getConditionDetails() {
        return "";
    }

    public abstract boolean testCondition() throws Exception;

    private void validatorEnsureTrue(boolean value, String msg) {
        if (!value) {
            throw new RuntimeException(msg);
        }
    }
}

