/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.collectsupportdata;

import com.pingidentity.csd.server.util.StaticUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PDMonitorFileUtils {
    private static final String DATE_FORMAT_GMT_TIME = "yyyyMMddHHmmss'Z'";
    private static final String TIME_ZONE_UTC = "UTC";
    private static final Pattern utcTimestampPattern = Pattern.compile("\\d{14}Z");

    private static Date parseRotationTimeStamp(File rotatedFile) {
        SimpleDateFormat utcTimestampFormat = new SimpleDateFormat(DATE_FORMAT_GMT_TIME);
        utcTimestampFormat.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_UTC));
        Matcher matcher = utcTimestampPattern.matcher(rotatedFile.getName());
        if (!matcher.find()) {
            return null;
        }
        String timestamp = matcher.group();
        try {
            return utcTimestampFormat.parse(timestamp);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static List<File> getFilesWithinRange(final File unrotatedFile, Date startInclusive, Date endInclusive) {
        File logDir = unrotatedFile.getParentFile();
        ArrayList<File> matchedFiles = new ArrayList<File>();
        if (logDir.exists() && logDir.isDirectory()) {
            File[] filesByRotationTime = StaticUtils.listFiles(logDir, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(unrotatedFile.getName() + "\\.\\d{14}Z\\.gz");
                }
            });
            Arrays.sort(filesByRotationTime, new RotationTimeComparator());
            for (File rotatedFile : filesByRotationTime) {
                Date rotationTime = PDMonitorFileUtils.parseRotationTimeStamp(rotatedFile);
                Date adjustedTime = new Date(rotationTime.getTime() + 1000L);
                if (!startInclusive.before(adjustedTime) || rotationTime.after(endInclusive)) continue;
                matchedFiles.add(rotatedFile);
            }
        }
        return matchedFiles;
    }

    public static List<File> getFilesNearAges(final File unrotatedFile, long now, long ... agesInMillis) {
        File logDir = unrotatedFile.getParentFile();
        ArrayList<File> matchedFiles = new ArrayList<File>();
        if (logDir.exists() && logDir.isDirectory()) {
            File[] filesByRotationTime = StaticUtils.listFiles(logDir, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(unrotatedFile.getName() + "\\.\\d{14}Z\\.gz");
                }
            });
            Arrays.sort(filesByRotationTime, new RotationTimeComparator());
            int i = 0;
            block0: for (long ageInMillis : agesInMillis) {
                while (i < filesByRotationTime.length) {
                    long age;
                    Date rotationTime = PDMonitorFileUtils.parseRotationTimeStamp(filesByRotationTime[i]);
                    if (rotationTime != null && (age = now - rotationTime.getTime()) >= ageInMillis) {
                        matchedFiles.add(filesByRotationTime[i]);
                        ++i;
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return matchedFiles;
    }

    private static class RotationTimeComparator<F extends File>
    implements Comparator<F> {
        private RotationTimeComparator() {
        }

        @Override
        public int compare(F f1, F f2) {
            Date d1 = PDMonitorFileUtils.parseRotationTimeStamp(f1);
            Date d2 = PDMonitorFileUtils.parseRotationTimeStamp(f2);
            if (d1 == null) {
                if (d2 == null) {
                    return 0;
                }
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d2.compareTo(d1);
        }
    }
}

