/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.LinuxExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SolarisExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BusyThreadsExaminer
extends SupportDataExaminer {
    @Override
    public List<OperatingSystem> getSupportedOperatingSystems() {
        return Arrays.asList(OperatingSystem.SOLARIS, OperatingSystem.LINUX);
    }

    @Override
    public String getTitle() {
        return "Busy Threads Analysis";
    }

    @Override
    public Message getExplanation() {
        return UBIDExaminerMessages.INFO_BUSY_THREADS_EXPLANATION.get();
    }

    @Override
    public SupportDataExaminer.Result examine(SupportDataArchive sda) {
        SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
        try {
            BusyThreadData busyThreadData = null;
            switch (sda.getSystem()) {
                case LINUX: {
                    busyThreadData = LinuxExaminer.getBusyThreadData(sda);
                    break;
                }
                case SOLARIS: {
                    busyThreadData = SolarisExaminer.getBusyThreadData(sda);
                    break;
                }
                default: {
                    return result;
                }
            }
            if ((double)busyThreadData.highestCpuUsage.floatValue() <= 0.0) {
                return result;
            }
            if ((double)busyThreadData.highestCpuUsage.floatValue() >= 50.0) {
                result.setSeverity(Severity.SEVERE_ERROR);
            } else if ((double)busyThreadData.highestCpuUsage.floatValue() >= 25.0) {
                result.setSeverity(Severity.MILD_ERROR);
            } else if ((double)busyThreadData.highestCpuUsage.floatValue() >= 10.0) {
                result.setSeverity(Severity.SEVERE_WARNING);
            } else {
                result.setSeverity(Severity.MILD_WARNING);
            }
            List<List<String>> jstackThreads = sda.getJstacksLines();
            if (jstackThreads == null) {
                result.setSeverity(null);
                return result;
            }
            result.writeln("Av CPU  Hi CPU  Busy Thread Details");
            block6: for (BusyThreadData.BusyThreadCpuUsage busyThreadCpuUsage : busyThreadData.getUsagesSortedByAvg()) {
                if ((double)busyThreadCpuUsage.highestCpuUsage.floatValue() < 0.1) continue;
                for (List<String> stackLines : jstackThreads) {
                    String header = stackLines.get(0);
                    if (!header.contains("nid=0x" + busyThreadCpuUsage.threadId)) continue;
                    result.writeln(String.format("%6.1f  %6.1f  %s", busyThreadCpuUsage.averageCpuUsage, busyThreadCpuUsage.highestCpuUsage, header));
                    continue block6;
                }
            }
            result.writeln("Stacks for Busiest Thread (Peak Usage at " + busyThreadData.highestCpuUsage + "%):");
            for (List list : jstackThreads) {
                String header = (String)list.get(0);
                if (!header.contains("nid=0x" + busyThreadData.busiestThreadId)) continue;
                for (String line : list) {
                    result.writeln(line);
                }
            }
        }
        catch (Exception ex) {
            this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
        }
        return result;
    }

    public static class BusyThreadData {
        private String busiestThreadId;
        private Float highestCpuUsage = Float.valueOf(Float.MIN_VALUE);
        private Map<String, BusyThreadCpuUsage> threadCpuUsageMap = new HashMap<String, BusyThreadCpuUsage>();

        public BusyThreadCpuUsage getUsageForThread(String threadId) {
            BusyThreadCpuUsage usage = this.threadCpuUsageMap.get(threadId);
            if (usage == null) {
                usage = new BusyThreadCpuUsage();
                usage.threadId = threadId;
                this.threadCpuUsageMap.put(threadId, usage);
            }
            return usage;
        }

        public void updateThreadCpuUsage(String threadId, Float cpuUsage) {
            BusyThreadCpuUsage usage = this.getUsageForThread(threadId);
            usage.updateUsage(cpuUsage);
            if (cpuUsage.floatValue() > this.highestCpuUsage.floatValue()) {
                this.busiestThreadId = threadId;
                this.highestCpuUsage = cpuUsage;
            }
        }

        public List<BusyThreadCpuUsage> getUsagesSortedByAvg() {
            ArrayList<BusyThreadCpuUsage> list = new ArrayList<BusyThreadCpuUsage>(this.threadCpuUsageMap.values());
            Collections.sort(list);
            return list;
        }

        static class BusyThreadCpuUsage
        implements Comparable<BusyThreadCpuUsage> {
            private String threadId;
            private Float averageCpuUsage = Float.valueOf(0.0f);
            private Float highestCpuUsage = Float.valueOf(Float.MIN_VALUE);
            private int dataPoints = 0;

            BusyThreadCpuUsage() {
            }

            @Override
            public int compareTo(BusyThreadCpuUsage o) {
                return this.averageCpuUsage.compareTo(o.averageCpuUsage);
            }

            public void updateUsage(Float cpuUsage) {
                if (this.highestCpuUsage.floatValue() < cpuUsage.floatValue()) {
                    this.highestCpuUsage = cpuUsage;
                }
                this.averageCpuUsage = Float.valueOf((this.averageCpuUsage.floatValue() * (float)this.dataPoints + cpuUsage.floatValue()) / (float)(this.dataPoints + 1));
                ++this.dataPoints;
            }
        }
    }
}

