/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.google.common.collect.ImmutableList;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.directory.server.util.StaticUtils;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class FileSystemExaminer
extends SupportDataExaminer {
    final String fullServerRootPath = "dir-listings/full-server-root";
    static final String FILE_TOO_LARGE_REGEX = Pattern.compile("Last \\d+ of \\d+ characters of input characters are shown:").pattern();
    static final String CONFIG_ARCHIVE_REGEX = Pattern.compile("(.*) config-(\\d+)(.*)gz$").pattern();

    public static List<SupportDataExaminer> getExaminers() {
        return ImmutableList.of((Object)new ConfigArchiveExaminer(), (Object)new LargeFileCountExaminer());
    }

    InputStream getFullServerRoot(SupportDataArchive sda) {
        InputStream stream = sda.getFileInputStream("dir-listings/full-server-root");
        if (stream == null) {
            String errorMessage = UBIDExaminerMessages.INFO_FILE_NOT_FOUND.get("dir-listings/full-server-root").toString();
            this.log(StaticUtils.punctuate((String)errorMessage));
        }
        return stream;
    }

    @Override
    public List<Category> getCategories() {
        return Collections.singletonList(Category.CONFIG);
    }

    public static class LargeFileCountExaminer
    extends FileSystemExaminer {
        @Override
        public String getTitle() {
            return "Large File Count Analysis";
        }

        @Override
        public Message getExplanation() {
            return StaticUtils.punctuate((Message)UBIDExaminerMessages.INFO_LARGE_FILESYSTEM_EXPLANATION.get("dir-listings/full-server-root"));
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) throws IOException {
            String line;
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            InputStream serverRootStream = this.getFullServerRoot(sda);
            if (serverRootStream == null) {
                result.setSeverity(Severity.SEVERE_ERROR);
                return result;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(serverRootStream));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                if (line.matches(FILE_TOO_LARGE_REGEX)) {
                    result.setSeverity(Severity.SEVERE_ERROR);
                    break;
                }
                result.setSeverity(Severity.INFORMATION);
                result.writeln(String.format("Checked for potential indications that the server contained a large file count. '%s' appears to have been fully collected, so the server root does not appear to be overwhelmingly large.", "dir-listings/full-server-root"));
                break;
            }
            return result;
        }
    }

    public static class ConfigArchiveExaminer
    extends FileSystemExaminer {
        static final int WARN_THRESHOLD = 2000;
        static final int ERROR_THRESHOLD = 5000;

        @Override
        public String getTitle() {
            return "Configuration Archive Analysis";
        }

        @Override
        public Message getExplanation() {
            return StaticUtils.punctuate((Message)UBIDExaminerMessages.INFO_CONFIG_ARCHIVE_EXPLANATION.get("dir-listings/full-server-root"));
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) throws IOException {
            String line;
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            InputStream serverRootStream = this.getFullServerRoot(sda);
            if (serverRootStream == null) {
                result.setSeverity(Severity.SEVERE_ERROR);
                return result;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(serverRootStream));
            int configArchiveCount = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty() || !line.contains("config-") || !line.matches(CONFIG_ARCHIVE_REGEX)) continue;
                ++configArchiveCount;
            }
            if (configArchiveCount >= 5000) {
                result.setSeverity(Severity.SEVERE_ERROR);
                result.writeln(String.format("Details: %,d configuration archive files were detected, which is greater than the error threshold of %,d.", configArchiveCount, 5000));
            } else if (configArchiveCount >= 2000) {
                result.setSeverity(Severity.SEVERE_WARNING);
                result.writeln(String.format("Details: %,d configuration archive files were detected, which is greater than the warning threshold of %,d.", configArchiveCount, 2000));
            } else {
                result.setSeverity(Severity.INFORMATION);
                this.log(String.format("%,d configuration archives were found, which is less than the warning threshold of %,d.", configArchiveCount, 2000));
            }
            return result;
        }
    }
}

