/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.util.Arrays;
import java.util.List;

public final class ThirdPartyExtensionExaminer
extends SupportDataExaminer {
    @Override
    public String getTitle() {
        return "Third-Party Extension Examiner";
    }

    @Override
    public Message getExplanation() {
        return UBIDExaminerMessages.INFO_THIRD_PARTY_EXTENSION_EXPLANATION.get();
    }

    @Override
    public List<Category> getCategories() {
        return Arrays.asList(Category.CONFIG);
    }

    @Override
    public SupportDataExaminer.Result examine(SupportDataArchive sda) {
        String[] extensionDNs;
        SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
        Entry e = sda.getMonitorEntry("cn=monitor");
        if (e != null && (extensionDNs = e.getAttributeValues("thirdPartyExtensionDN")) != null && extensionDNs.length > 0) {
            result.setSeverity(Severity.NOTICE);
            result.write("One or more third-party extensions have been configured in the server:  ");
            for (int i = 0; i < extensionDNs.length; ++i) {
                if (i > 0) {
                    result.write(", ");
                }
                result.write("'");
                result.write(extensionDNs[i]);
                result.write("'");
            }
            result.writeln();
        }
        return result;
    }
}

