/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.build.tools.messages;

import com.unboundid.build.tools.messages.GenerateMessagesFile;
import com.unboundid.build.tools.messages.MessageDescriptorDeclaration;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class GenerateJavaMessageFile
extends GenerateMessagesFile {
    private File registryFile;

    public GenerateJavaMessageFile() {
        super("java");
    }

    public void setRegistryFile(File registryFile) {
        this.registryFile = registryFile;
    }

    @Override
    protected String getDescriptorString(MessageDescriptorDeclaration decl) {
        return decl.toJava();
    }

    @Override
    protected void postProcess() throws Exception {
        this.registerMessageDescriptor(this.getMessageDescriptorFullClassName());
    }

    @Override
    protected void createProductPropertiesSourceFile(File dest) throws IOException {
        Properties p = new Properties();
        FileReader r = new FileReader(this.productFile);
        p.load(r);
        r.close();
        PrintWriter w = new PrintWriter(dest);
        w.println("package com.unboundid.messages;");
        w.println();
        w.println("public class ProductProperties");
        w.println("{");
        for (String name : p.stringPropertyNames()) {
            w.println("  public static String " + name + " = \"" + p.getProperty(name) + "\";");
        }
        w.println("}");
        w.close();
    }

    private boolean registerMessageDescriptor(String descClassName) throws IOException {
        boolean classAdded = false;
        File registry = this.getRegistryFile();
        if (!this.isDescriptorRegistered(descClassName)) {
            FileOutputStream file = new FileOutputStream(registry, true);
            DataOutputStream out = new DataOutputStream(file);
            out.writeBytes(descClassName);
            out.writeBytes("\n");
            out.flush();
            out.close();
        }
        return classAdded;
    }

    private boolean isDescriptorRegistered(String descClassName) throws IOException {
        String line;
        boolean isRegistered = false;
        BufferedReader reader = new BufferedReader(new FileReader(this.getRegistryFile()));
        while (null != (line = reader.readLine())) {
            if (!line.trim().equals(descClassName.trim())) continue;
            isRegistered = true;
            break;
        }
        return isRegistered;
    }

    private File getRegistryFile() throws IOException {
        if (this.registryFile == null) {
            throw new IllegalStateException("registryFile not specified");
        }
        File registry = this.registryFile;
        if (!registry.exists()) {
            File parent = registry.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            registry.createNewFile();
        }
        return registry;
    }

    public static void main(String[] args) {
        File source = new File("resource/messages/ubid_tools.properties");
        File dest = new File("/tmp/com/unboundid/XXX.java");
        File product = new File("resource/products/ds/product.info");
        GenerateJavaMessageFile gmf = new GenerateJavaMessageFile();
        gmf.setOverwrite(true);
        gmf.setDestSourceCodeFile(dest);
        gmf.setSourceProps(source);
        gmf.setProductFile(product);
        gmf.execute();
    }
}

